/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.ConditionalValue;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface UpdateValueSetCommand
extends UpdateCommand<ValueSetId, ValueSetState> {
    @Value.Parameter(order=1)
    public List<Value<ValueSet.Entry>> getEntries();

    @Override
    @Nonnull
    default public Set<EventMatcher> getEventMatchers() {
        return this.getEntries().stream().flatMap(entryValue -> {
            Stream<Object> eventMatchers = Stream.empty();
            if (entryValue instanceof ConditionalValue) {
                ConditionalValue conditionalValue = (ConditionalValue)entryValue;
                eventMatchers = conditionalValue.getWhen().getEvalRequiredConditions().stream();
            }
            return Stream.concat(Stream.of(EventMatchers.whenSessionLocaleUpdated()), eventMatchers);
        }).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    default public ValueSetState update(@Nonnull EvalContext context, @Nonnull ValueSetState state) {
        List<ValueSetState.Entry> entries = Stream.concat(this.getEntries().stream().map(entryValue -> (ValueSet.Entry)entryValue.eval(context)).filter(Objects::nonNull).map(entry -> ValueSetState.Entry.of(entry.getKey(), (String)entry.getLabel().eval(context))), state.getEntries().stream().filter(ValueSetState.Entry::isProvided)).collect(Collectors.toList());
        return state.update().setEntries(entries).get();
    }
}

