/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorId", generator="Immutables")
@Immutable
public final class ImmutableErrorId
implements ErrorId {
    private final ItemId itemId;
    @Nullable
    private final String code;

    private ImmutableErrorId(ItemId itemId, @Nullable String code) {
        this.itemId = Objects.requireNonNull(itemId, "itemId");
        this.code = code;
    }

    private ImmutableErrorId(ImmutableErrorId original, ItemId itemId, @Nullable String code) {
        this.itemId = itemId;
        this.code = code;
    }

    @Override
    public ItemId getItemId() {
        return this.itemId;
    }

    @Override
    @Nullable
    public String getCode() {
        return this.code;
    }

    @Override
    public final ImmutableErrorId withItemId(ItemId value) {
        if (this.itemId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "itemId");
        return new ImmutableErrorId(this, newValue, this.code);
    }

    public final ImmutableErrorId withCode(@Nullable String value) {
        if (Objects.equals(this.code, value)) {
            return this;
        }
        return new ImmutableErrorId(this, this.itemId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorId && this.equalTo((ImmutableErrorId)another);
    }

    private boolean equalTo(ImmutableErrorId another) {
        return this.itemId.equals(another.itemId) && Objects.equals(this.code, another.code);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.itemId.hashCode();
        h += (h << 5) + Objects.hashCode(this.code);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorId").omitNullValues().add("itemId", (Object)this.itemId).add("code", (Object)this.code).toString();
    }

    public static ImmutableErrorId of(ItemId itemId, @Nullable String code) {
        return new ImmutableErrorId(itemId, code);
    }

    public static ImmutableErrorId copyOf(ErrorId instance) {
        if (instance instanceof ImmutableErrorId) {
            return (ImmutableErrorId)instance;
        }
        return ImmutableErrorId.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorId", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ITEM_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private ItemId itemId;
        @Nullable
        private String code;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErrorId instance) {
            Objects.requireNonNull(instance, "instance");
            this.itemId(instance.getItemId());
            String codeValue = instance.getCode();
            if (codeValue != null) {
                this.code(codeValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder itemId(ItemId itemId) {
            this.itemId = Objects.requireNonNull(itemId, "itemId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder code(@Nullable String code) {
            this.code = code;
            return this;
        }

        public ImmutableErrorId build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorId(null, this.itemId, this.code);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("itemId");
            }
            return "Cannot build ErrorId, some of required attributes are not set " + attributes;
        }
    }
}

