/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValueSetId", generator="Immutables")
@Immutable
public final class ImmutableValueSetId
implements ValueSetId {
    private final String valueSetId;

    private ImmutableValueSetId(String valueSetId) {
        this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
    }

    private ImmutableValueSetId(ImmutableValueSetId original, String valueSetId) {
        this.valueSetId = valueSetId;
    }

    @Override
    public String getValueSetId() {
        return this.valueSetId;
    }

    public final ImmutableValueSetId withValueSetId(String value) {
        String newValue = Objects.requireNonNull(value, "valueSetId");
        if (this.valueSetId.equals(newValue)) {
            return this;
        }
        return new ImmutableValueSetId(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueSetId && this.equalTo((ImmutableValueSetId)another);
    }

    private boolean equalTo(ImmutableValueSetId another) {
        return this.valueSetId.equals(another.valueSetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueSetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueSetId").omitNullValues().add("valueSetId", (Object)this.valueSetId).toString();
    }

    public static ImmutableValueSetId of(String valueSetId) {
        return new ImmutableValueSetId(valueSetId);
    }

    public static ImmutableValueSetId copyOf(ValueSetId instance) {
        if (instance instanceof ImmutableValueSetId) {
            return (ImmutableValueSetId)instance;
        }
        return ImmutableValueSetId.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueSetId", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE_SET_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String valueSetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValueSetId instance) {
            Objects.requireNonNull(instance, "instance");
            this.valueSetId(instance.getValueSetId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(String valueSetId) {
            this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableValueSetId build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueSetId(null, this.valueSetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueSetId");
            }
            return "Cannot build ValueSetId, some of required attributes are not set " + attributes;
        }
    }
}

