/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableItemRef;
import io.dialob.session.engine.session.model.ItemId;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.immutables.value.Value;

@Value.Immutable
public interface Scope
extends Serializable {
    @Nonnull
    @Value.Parameter(order=-1000)
    public ItemId getScopeId();

    @Value.Parameter
    public Set<ItemId> getScopeItems();

    default public ItemId mapTo(ItemId itemId, boolean ignoreScopeItems) {
        return this.getScopeId().getParent().map(scopeParent -> {
            ItemId parentId;
            ItemId scopedId = itemId;
            if (!itemId.getParent().isPresent()) {
                scopedId = ImmutableItemRef.of(itemId.getValue(), Optional.of(this.getScopeId()));
            } else if (IdUtils.matches(itemId, this.getScopeId())) {
                scopedId = this.getScopeId();
            } else if (itemId.isPartial() && itemId.getParent().isPresent() && IdUtils.matches(parentId = itemId.getParent().get(), this.getScopeId())) {
                scopedId = itemId.withParent(this.getScopeId());
            }
            if (!ignoreScopeItems && !this.getScopeItems().contains(scopedId)) {
                scopedId = itemId;
            }
            return scopedId;
        }).orElse(itemId);
    }
}

