package io.digified.digified_library.api.callbacks;

import io.digified.digified_library.capture.CaptureResult;
import io.digified.digified_library.digified.Digified;

public interface ProgressCallback {

    /**
     * This method is called when we the SDK sending and processing the API request
     *
     * @param captureType the capture type of the CaptureResult you are sending to the API via
     *                    {@link Digified#send(CaptureResult, IdExtractionCallback)} or
     *                    {@link Digified#send(CaptureResult, FaceMatchCallback)}
     * @param progress    integer representing the progress of the uploading
     */
    void onUploadProgress(int captureType, int progress);

    /**
     * This method is called when the uploading process of the image is done,
     * so now the processing of the image has started
     *
     * @param captureType the capture type of the CaptureResult you are sending to the API via
     *                    {@link Digified#send(CaptureResult, IdExtractionCallback)} or
     *                    {@link Digified#send(CaptureResult, FaceMatchCallback)}
     */
    void onUploadingDone(int captureType);

}
