package io.digified.digified_library.api.network;


import java.util.HashMap;

import io.digified.digified_library.api.ApiConstants;
import io.digified.digified_library.api.result.FaceMatchResult;
import io.digified.digified_library.api.result.GenericIdExtractionResult;
import io.digified.digified_library.api.result.GenericIdFetchedResult;
import io.digified.digified_library.api.result.IdExtractionResult;
import io.digified.digified_library.api.result.IdFetchedResult;
import io.digified.digified_library.api.result.InitializationResult;
import io.digified.digified_library.api.result.PassportExtractionResult;
import io.digified.digified_library.api.result.PassportFetchedResult;
import io.digified.digified_library.api.result.TransliterationResult;
import io.digified.digified_library.api.result.VehicleLicenseExtractionResult;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PartMap;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface DigifiedAPI {

    @FormUrlEncoded
    @POST(ApiConstants.Url.INIT_REQUEST)
    Call<InitializationResult> init(@FieldMap HashMap<String, String> hashMap);

    @Multipart
    @POST(ApiConstants.Url.EXTRACT_REQUEST)
    Call<IdExtractionResult> extractID(@PartMap HashMap<String, RequestBody> hashMap);

    @Multipart
    @POST(ApiConstants.Url.EXTRACT_REQUEST)
    Call<GenericIdExtractionResult> extractGenericID(@PartMap HashMap<String, RequestBody> hashMap);


    @Multipart
    @POST(ApiConstants.Url.EXTRACT_REQUEST)
    Call<VehicleLicenseExtractionResult> extractVehicleLicense(@PartMap HashMap<String, RequestBody> hashMap);


    @Multipart
    @POST(ApiConstants.Url.EXTRACT_REQUEST)
    Call<PassportExtractionResult> extractPassport(@PartMap HashMap<String, RequestBody> hashMap);

    @Multipart
    @POST(ApiConstants.Url.FACE_MATCHING_REQUEST)
    Call<FaceMatchResult> faceMatch(@PartMap HashMap<String, RequestBody> hashMap);

    @FormUrlEncoded
    @POST(ApiConstants.Url.TRANSLITERATE)
    Call<TransliterationResult> transliterate(@FieldMap HashMap<String, String> hashMap);

    @GET(ApiConstants.Url.RESULTS)
    Call<IdFetchedResult> fetchIdResults(@Query(ApiConstants.ParamsKeys.TOKEN) String token);


    @GET(ApiConstants.Url.RESULTS)
    Call<PassportFetchedResult> fetchPassportResults(@Query(ApiConstants.ParamsKeys.TOKEN) String token);

    @GET(ApiConstants.Url.RESULTS)
    Call<GenericIdFetchedResult> fetchGenericIdResults(@Query(ApiConstants.ParamsKeys.TOKEN) String token);

//    @FormUrlEncoded
//    @POST(ApiConstants.Url.RESULTS)
//    Call<Ve> fetchVehicleLicenseResults(@FieldMap HashMap<String, String> hashMap);


    @GET
    Call<ResponseBody> downloadImageBitmap(@Url String imageUrl);

//
//    @FormUrlEncoded
//    @POST(ApiConstants.Url.FRAUD_REQUEST)
//    Call<FraudCheckResult> checkFraud(@Field("first-name") String firstName,
//                                      @Field("family-name") String familyName,
//                                      @Field("address-line-1") String addressLine1,
//                                      @Field("serial") String serialNumber,
//                                      @Field("district") String district,
//                                      @Field("governorate") String governorate,
//                                      @Field("front-id") Integer frontId,
//                                      @Field("job") String job,
//                                      @Field("gender") String gender,
//                                      @Field("religion") String religion,
//                                      @Field("martial-status") String martialStatus,
//                                      @Field("expiry-date") String expiryDate,
//                                      @Field("back-id") Integer backId,
//                                      @Field("token") String token);


}
