package io.digified.digified_library.api.network;

import android.os.Handler;
import android.os.Looper;

import io.digified.digified_library.api.callbacks.ProgressCallback;

public class ProgressUpdater {

    private static final String TAG = "ProgressUpdater";
    private final int mCaptureType;
    private final ProgressCallback mProgressCallback;

    private long mAccumulatedUpload;
    private long mLastUploaded;
    private long mTotalFilesSize;
    private int currentProgress;
    private int mNewProgress;
    private boolean mIsThreadRunning;
    private final Handler mHandler;
    private final ProgressUpdaterRunnable progressUpdaterRunnable;


    public ProgressUpdater(int captureType, ProgressCallback progressCallback) {
//        Log.e(TAG, "ProgressUpdater");
        mCaptureType = captureType;
        mProgressCallback = progressCallback;
        currentProgress = 0;
        mLastUploaded = 0;
        mNewProgress = 0;
        mHandler = new Handler(Looper.getMainLooper());
        mIsThreadRunning = false;
        progressUpdaterRunnable = new ProgressUpdaterRunnable();

    }

    public void addFile(int fileSize) {
        mTotalFilesSize += fileSize;
    }

    public void setCurrentProgress(long uploaded) {

//        Log.e(TAG, "ProgressUpdaterRunnable::: setCurrentProgress = " + uploaded);

        if (uploaded > mLastUploaded) {
            mAccumulatedUpload += uploaded - mLastUploaded;
        }

        mLastUploaded = uploaded;

        float temp = (float) 100 * mAccumulatedUpload / mTotalFilesSize;

        mNewProgress = (int) Math.ceil(temp);

        if (!mIsThreadRunning) {
//            Log.e(TAG, "ProgressUpdaterRunnable::: will run it!");
            mIsThreadRunning = true;
            mHandler.post(progressUpdaterRunnable);
        }
    }


    public class ProgressUpdaterRunnable implements Runnable {

        @Override
        public void run() {
//            Log.e(TAG, "ProgressUpdaterRunnable::: run:, mNewProgress = " + mNewProgress + ", currentProgress = " + currentProgress);
            if (mNewProgress != currentProgress) {
                currentProgress = mNewProgress;
                mProgressCallback.onUploadProgress(mCaptureType, currentProgress);
                if (currentProgress == 100) {
                    mProgressCallback.onUploadingDone(mCaptureType);
                }
            }
            mIsThreadRunning = false;
        }
    }
}