package io.digified.digified_library.api.result;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import java.io.BufferedInputStream;
import java.io.InputStream;

import okhttp3.ResponseBody;

public class DigifiedBitmapResult extends BaseDigifiedResult {

    private final Bitmap downloadedBitmap;

    public DigifiedBitmapResult(ResponseBody responseBody) {
        InputStream bis = new BufferedInputStream(responseBody.byteStream(), 1024 * 8);
        downloadedBitmap = BitmapFactory.decodeStream(bis);
    }

    public Bitmap getDownloadedBitmap() {
        return downloadedBitmap;
    }
}
