package io.digified.digified_library.api.result;

import com.google.gson.annotations.SerializedName;

import io.digified.digified_library.api.result.internal.generic_id.GenericIdBackData;
import io.digified.digified_library.api.result.internal.generic_id.GenericIdFrontData;

public class GenericIdExtractionResult extends DigifiedResult {

    @SerializedName("front")
    private GenericIdFrontData genericIdFrontData;

    @SerializedName("back")
    private GenericIdBackData genericIdBackData;

    /**
     * Getter method for {@link #genericIdFrontData}: data of the front side of the id
     *
     * @return "front" in the API response
     */
    public GenericIdFrontData getGenericIdFrontData() {
        return genericIdFrontData;
    }

    /**
     * Getter method for {@link #genericIdBackData}: data of the back side of the id
     *
     * @return "back" in the API response
     */
    public GenericIdBackData getGenericIdBackData() {
        return genericIdBackData;
    }

    /**
     * Setter method for the {@link #genericIdFrontData}: data of the front side of the id
     *
     * @param genericIdFrontData "front" in the API response
     */
    public void setGenericIdFrontData(GenericIdFrontData genericIdFrontData) {
        this.genericIdFrontData = genericIdFrontData;
    }


}
