package io.digified.digified_library.api.result;

import com.google.gson.annotations.SerializedName;

public class TransliterationResult extends DigifiedResult {

    @SerializedName("arabic_name")
    private String arabicName;

    @SerializedName("transliterated_name")
    private String transliteratedName;

    @SerializedName("transliterated_second_name")
    private String transliteratedSecondName;

    @SerializedName("transliterated_surname")
    private String transliteratedSurname;

    @SerializedName("transliterated_street")
    private String transliteratedStreet;

    @SerializedName("transliterated_subdistrict")
    private String transliteratedSubdistrict;

    @SerializedName("transliterated_district")
    private String transliteratedDistrict;

    @SerializedName("transliterated_governorate")
    private String transliteratedGovernorate;

    @SerializedName("transliterated_family_name")
    private String transliteratedFamilyName;

    @SerializedName("not_transliterated")
    private String notTransliterated;


    /**
     * Getter method for {@link #arabicName}: The name in arabic
     *
     * @return "arabic_name" in the API response
     */
    public String getArabicName() {
        return arabicName;
    }

    /**
     * Getter method for {@link #transliteratedName}: The first name in english
     *
     * @return "transliterated_name" in the API response
     */
    public String getTransliteratedName() {
        return transliteratedName;
    }

    /**
     * Getter method for {@link #transliteratedFamilyName}: The family name in english
     *
     * @return "transliterated_family_name" in the API response
     */
    public String getTransliteratedFamilyName() {
        return transliteratedFamilyName;
    }

    /**
     * Getter method for {@link #transliteratedSecondName}: The second name in arabic
     *
     * @return "transliterated_second_name" in the API response
     */
    public String getTransliteratedSecondName() {
        return transliteratedSecondName;
    }

    /**
     * Getter method for {@link #transliteratedSurname}: The second name in arabic
     *
     * @return "transliterated_surname" in the API response
     */
    public String getTransliteratedSurname() {
        return transliteratedSurname;
    }

    /**
     * Getter method for {@link #transliteratedStreet}: The second name in arabic
     *
     * @return "transliterated_street" in the API response
     */
    public String getTransliteratedStreet() {
        return transliteratedStreet;
    }

    /**
     * Getter method for {@link #transliteratedSubdistrict}: The second name in arabic
     *
     * @return "transliterated_subdistrict" in the API response
     */
    public String getTransliteratedSubdistrict() {
        return transliteratedSubdistrict;
    }

    /**
     * Getter method for {@link #transliteratedDistrict}: The second name in arabic
     *
     * @return "transliterated_district" in the API response
     */
    public String getTransliteratedDistrict() {
        return transliteratedDistrict;
    }

    /**
     * Getter method for {@link #transliteratedGovernorate}: The governorate name in arabic
     *
     * @return "transliterated_governorate" in the API response
     */
    public String getTransliteratedGovernorate() {
        return transliteratedGovernorate;
    }

    /**
     * Getter method for {@link #notTransliterated}: not transliterated names
     *
     * @return "not_transliterated" in the API response
     */
    public String getNotTransliterated() {
        return notTransliterated;
    }
}
