package io.digified.digified_library.api.result.internal.generic_id;

import com.google.gson.annotations.SerializedName;

public class GenericIdBackData extends GenericIdData{

    @SerializedName("address")
    private String address;

    @SerializedName("address house")
    private String addressHouse;

    @SerializedName("address_area")
    private String addressArea;

    @SerializedName("address_city")
    private String addressCity;

    @SerializedName("address_location")
    private String addressLocation;

    @SerializedName("address_state")
    private String addressState;

    @SerializedName("profession")
    private String profession;

    /**
     * Getter method for {@link #address}, address on the id
     *
     * @return "address" in the API response
     */
    public String getAddress() {
        return address;
    }

    /**
     * Getter method for {@link #addressHouse}, address house on the id
     *
     * @return "address house" in the API response
     */
    public String getAddressHouse() {
        return addressHouse;
    }

    /**
     * Getter method for {@link #addressArea}, address area on the id
     *
     * @return "address_area" in the API response
     */
    public String getAddressArea() {
        return addressArea;
    }

    /**
     * Getter method for {@link #addressCity}, address city on the id
     *
     * @return "address_city" in the API response
     */
    public String getAddressCity() {
        return addressCity;
    }

    /**
     * Getter method for {@link #addressLocation}, address location on the id
     *
     * @return "address_location" in the API response
     */
    public String getAddressLocation() {
        return addressLocation;
    }

    /**
     * Getter method for {@link #addressState}, address state on the id
     *
     * @return "address_state" in the API response
     */
    public String getAddressState() {
        return addressState;
    }

    /**
     * Getter method for {@link #profession}, profession on the id
     *
     * @return "profession" in the API response
     */
    public String getProfession() {
        return profession;
    }
}
