package io.digified.digified_library.api.result.internal.generic_id;

import com.google.gson.annotations.SerializedName;

public class GenericIdFrontData extends GenericIdData{



    @SerializedName("additional_id_number")
    private String additionalIdNumber;

    @SerializedName("arabic_name")
    private String arabicName;

    @SerializedName("country")
    private String country;

    @SerializedName("district_of_birth")
    private String districtOfBirth;

    @SerializedName("full_name")
    private String fullName;

    @SerializedName("id_number")
    private String idNumber;

    @SerializedName("identifier")
    private String identifier;

    @SerializedName("issue_date")
    private String issueDate;

    /**
     * Getter method for {@link #additionalIdNumber}, additional id number on the id
     *
     * @return "additional_id_number" in the API response
     */
    public String getAdditionalIdNumber() {
        return additionalIdNumber;
    }

    /**
     * Getter method for {@link #arabicName}, arabic name on the id
     *
     * @return "arabic_name" in the API response
     */
    public String getArabicName() {
        return arabicName;
    }

    /**
     * Getter method for {@link #country}, country on the id
     *
     * @return "country" in the API response
     */
    public String getCountry() {
        return country;
    }

    /**
     * Getter method for {@link #districtOfBirth}, district of birth on the id
     *
     * @return "district_of_birth" in the API response
     */
    public String getDistrictOfBirth() {
        return districtOfBirth;
    }

    /**
     * Getter method for {@link #fullName}, full name on the id
     *
     * @return "full_name" in the API response
     */
    public String getFullName() {
        return fullName;
    }

    /**
     * Getter method for {@link #idNumber}, id number on the id
     *
     * @return "id_number" in the API response
     */
    public String getIdNumber() {
        return idNumber;
    }

    /**
     * Getter method for {@link #identifier}, identifier on the id
     *
     * @return "identifier" in the API response
     */
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Getter method for {@link #issueDate}, issue date on the id
     *
     * @return "issue_date" in the API response
     */
    public String getIssueDate() {
        return issueDate;
    }
}
