package io.digified.digified_library.api.result.internal.id;

import com.google.gson.annotations.SerializedName;

public class BackIdData extends IdData {

    @SerializedName("expiration")
    private String expirationDate;

    @SerializedName("isExpired")
    private Boolean isExpired;

    @SerializedName("job_title")
    private String jobTitle;

    @SerializedName("job_place")
    private String jobPlace;

    @SerializedName("marital")
    private String maritalStatus;

    @SerializedName("Husband")
    private String husband;

    @SerializedName("religion")
    private String religion;

    @SerializedName("sex")
    private String sex;

    @SerializedName("issue_date")
    private String issueDate;

//    /**
//     * Constructor for BackIdData
//     *
//     * @param nationalId     "national_id" in the API response, 14 digits integer representing the ID number
//     * @param imageUrl       "image" in the API response, URL link to cropped back ID
//     * @param expirationDate "expiration" in the API response, expiration date of the ID
//     * @param isExpired      "isExpired" in the API response, True if the ID is expired and False if not expired
//     * @param jobTitle       "job_title" in the API response, representing the job title
//     * @param jobPlace       "job_place" in the API response, representing the job place
//     * @param maritalStatus  "marital" in the API response, marital status
//     * @param husband        "Husband" in the API response, husband name
//     * @param religion       "religion" in the API response, religion
//     * @param sex            "sex" in the API response, gender
//     */
//    public BackIdData(Long nationalId,
//                      String imageUrl,
//                      String expirationDate,
//                      Boolean isExpired,
//                      String jobTitle,
//                      String jobPlace,
//                      String maritalStatus,
//                      String husband,
//                      String religion,
//                      String sex) {
//        super(nationalId, imageUrl);
//        this.expirationDate = expirationDate;
//        this.isExpired = isExpired;
//        this.jobTitle = jobTitle;
//        this.jobPlace = jobPlace;
//        this.maritalStatus = maritalStatus;
//        this.husband = husband;
//        this.religion = religion;
//        this.sex = sex;
//    }

    /**
     * Getter method for {@link #expirationDate}: expiration date of the ID
     *
     * @return "expiration" in the API response
     */
    public String getExpirationDate() {
        return expirationDate;
    }

    /**
     * Getter method for {@link #isExpired}: True if the ID is expired and False if not expired
     *
     * @return "isExpired" in the API response
     */
    public Boolean getExpired() {
        return isExpired;
    }

    /**
     * Getter method for {@link #jobTitle}: representing the job title
     *
     * @return "job_title" in the API response
     */
    public String getJobTitle() {
        return jobTitle;
    }

    /**
     * Getter method for {@link #jobPlace}: representing the job place
     *
     * @return "job_place" in the API response
     */
    public String getJobPlace() {
        return jobPlace;
    }

    /**
     * Getter method for {@link #maritalStatus}: marital status
     *
     * @return "marital" in the API response
     */
    public String getMaritalStatus() {
        return maritalStatus;
    }

    /**
     * Getter method for {@link #husband}: husband name
     *
     * @return "Husband" in the API response
     */
    public String getHusbandName() {
        return husband;
    }

    /**
     * Getter method for {@link #religion}: religion
     *
     * @return "religion" in the API response
     */
    public String getReligion() {
        return religion;
    }

    /**
     * Getter method for {@link #sex}: gender
     *
     * @return "sex" in the API response
     */
    public String getSex() {
        return sex;
    }

    /**
     * Getter method for {@link #issueDate}: gender
     * @return "issue_date" in the API response
     */
    public String getIssueDate() {
        return issueDate;
    }
}
