package io.digified.digified_library.authorize;

import android.graphics.Bitmap;

import androidx.fragment.app.FragmentManager;

import java.util.ArrayList;

import io.digified.digified_library.api.ApiManager;
import io.digified.digified_library.api.callbacks.DownloadImageCallback;
import io.digified.digified_library.api.callbacks.FaceMatchCallback;
import io.digified.digified_library.api.callbacks.IdCompletedVerificationCallback;
import io.digified.digified_library.api.result.DigifiedBitmapResult;
import io.digified.digified_library.api.result.FaceMatchResult;
import io.digified.digified_library.api.result.IdFetchedResult;
import io.digified.digified_library.api.result.internal.fetched.BaseFetchedData;
import io.digified.digified_library.api.result.internal.fetched.FaceFetchedData;
import io.digified.digified_library.api.result.internal.fetched.IdFetchedData;
import io.digified.digified_library.capture.CaptureCallback;
import io.digified.digified_library.capture.CaptureManager;
import io.digified.digified_library.capture.CaptureResult;
import io.digified.digified_library.capture.CaptureScreenMetaData;
import io.digified.digified_library.digified.DigifiedConstants;
import io.digified.digified_library.errors.DigifiedError;
import io.digified.digified_library.errors.ErrorConstants;

public class DigifiedAuthorizationManager {

    private ApiManager apiManager;
    private CaptureManager captureManager;

    private DigifiedAuthorizationCallback callback;
//    private String selfieImageUrl;
//    private int verificationStatus;
//    private boolean fetchingResultsDone;
//    private Bitmap downloadedBitmap;
//    private Bitmap capturedBitmap;


    public DigifiedAuthorizationManager(ApiManager apiManager, CaptureManager captureManager) {
        this.apiManager = apiManager;
        this.captureManager = captureManager;
        callback = null;
    }

    public void runAuthorizationCheck(String oldToken,
                                      FragmentManager fragmentManager,
                                      int captureContainerId,
                                      CaptureScreenMetaData captureScreenMetaData,
                                      DigifiedAuthorizationCallback digifiedAuthorizationCallback) {
        this.callback = digifiedAuthorizationCallback;
        callback.onProcessing();

        if (fragmentManager == null) {
            if (callback != null)
                callback.onFailure(new DigifiedError(ErrorConstants.CaptureError.CAMERA_ERROR));
        }

        captureManager.capture(fragmentManager, captureContainerId, DigifiedConstants.CaptureType.SELFIE, captureScreenMetaData, new CaptureCallback() {
            @Override
            public void onCaptured(CaptureResult captureResult) {
                match(captureResult, oldToken);
            }

            @Override
            public void onFailed(DigifiedError digifiedError, int captureType) {
                if (callback != null) callback.onFailure(digifiedError);
            }

            @Override
            public void onCancelled(int captureType) {
                if (callback != null)
                    callback.onResult(DigifiedConstants.Authorization.INTERRUPTED, null);
            }

            @Override
            public void onTimeout() {
                if (callback != null) callback.onCapturingTimeout();
            }
        });

    }


    private void match(CaptureResult captureResult, String oldToken) {
        ArrayList<String> capturedBitmapBase64List = captureManager.buildBase64List(captureResult);
        apiManager.faceMatch(capturedBitmapBase64List, oldToken, new FaceMatchCallback() {
            @Override
            public void onResult(FaceMatchResult result) {
                if (result == null) {
                    if (callback != null)
                        callback.onFailure(new DigifiedError(ErrorConstants.SendError.RESPONSE_ERROR));
                    return;
                }

                String error = result.getError();

                if (error != null && !error.isEmpty()) {
                    if (callback != null)
                        callback.onResult(DigifiedConstants.Authorization.FORBID, result);
                    return;
                }

                if (callback != null)
                    callback.onResult(DigifiedConstants.Authorization.AUTHORIZE, result);
            }

            @Override
            public void onFailure(DigifiedError digifiedError) {
                if (callback != null) callback.onFailure(digifiedError);
            }

            @Override
            public void onUploadProgress(int captureType, int progress) {

            }

            @Override
            public void onUploadingDone(int captureType) {

            }
        });

    }


}
