package io.digified.digified_library.capture;

import io.digified.digified_library.digified.DigifiedConstants;
import io.digified.digified_library.errors.DigifiedError;
import io.digified.digified_library.errors.ErrorConstants;

public interface CaptureCallback {

    /**
     * This method is called when we have a successful CaptureResult
     *
     * @param captureResult the capture result of your capture request
     */
    void onCaptured(CaptureResult captureResult);

    /**
     * This method is called when there is a problem with the capture request
     *
     * @param digifiedError the error that caused the request to fail
     *                      (you can find error codes here {@link ErrorConstants})
     * @param captureType   the capture type you wanted to capture (you can find capture types here
     *                      {@link DigifiedConstants.CaptureType}
     */
    void onFailed(DigifiedError digifiedError, int captureType);

    /**
     * This method is called when the user pauses the app during capturing request
     *
     * @param captureType the capture type you wanted to capture (you can find capture types here
     *                    {@link DigifiedConstants.CaptureType}
     */
    void onCancelled(int captureType);

    /**
     * This method is called if the time out of the capture process has passed
     */
    void onTimeout();
}
