package io.digified.digified_library.capture;

import android.graphics.Bitmap;

import java.util.ArrayList;

import io.digified.digified_library.digified.DigifiedConstants;

public class CaptureResult {

    private final int captureType;
    //    private final Bitmap bestCapturedFrame;
    private final ArrayList<Bitmap> capturedFramesArrayList;

    /**
     * Constructor for the captured result object
     *
     * @param captureType             capture type from {@link DigifiedConstants.CaptureType}
     *                                //     * @param bestCapturedFrame the best captured frame
     * @param capturedFramesArrayList all captured frames
     */
//    public CaptureResult(int captureType, Bitmap bestCapturedFrame, ArrayList<Bitmap> capturedFramesArrayList) {
    public CaptureResult(int captureType, ArrayList<Bitmap> capturedFramesArrayList) {
        this.captureType = captureType;
//        this.bestCapturedFrame = bestCapturedFrame;
        this.capturedFramesArrayList = capturedFramesArrayList;
    }

    /**
     * Getter method for {@link #captureType}
     *
     * @return the capture type of this CaptureResult
     */
    public int getCaptureType() {
        return captureType;
    }

    /**
     * Getter method for the last image in {@link #capturedFramesArrayList}
     *
     * @return captured Bitmap of this CaptureResult
     */
    public Bitmap getCapturedBitmap() {
        return capturedFramesArrayList.get(capturedFramesArrayList.size() - 1);
    }


    /**
     * Getter method for {@link #capturedFramesArrayList}
     *
     * @return an ArrayList of all captured frames
     */
    public ArrayList<Bitmap> getCapturedFramesArrayList() {
        return capturedFramesArrayList;
    }


}
