package io.digified.digified_library.capture;


public class CaptureScreenMetaData {

    private Integer titleId;
    private Integer subTitleId;
    private boolean enableDefaultCancelButton;

    private CaptureScreenMetaData() {
        this.titleId = null;
        this.subTitleId = null;
        this.enableDefaultCancelButton = false;
    }

    /**
     * Getter method for the custom title resource id
     * @return the custom title resource id
     */
    public Integer getTitleId() {
        return titleId;
    }

    /**
     * Getter method for the custom subtitle resource id
     * @return the custom subtitle resource id
     */
    public Integer getSubTitleId() {
        return subTitleId;
    }

    /**
     * checking if the default cancel button is enabled or not
     * @return whether the default cancel button is enabled or not
     */
    public boolean isDefaultCancelButtonEnabled() {
        return enableDefaultCancelButton;
    }

    private void setTitleId(Integer titleId) {
        this.titleId = titleId;
    }

    private void setSubtitleId(Integer subTitleId) {
        this.subTitleId = subTitleId;
    }

    private void setDefaultCancelButtonEnabled() {
        this.enableDefaultCancelButton = true;
    }

    /**
     * Builder class for the {@link CaptureScreenMetaData}
     */
    public static class Builder {

        private final CaptureScreenMetaData captureScreenMetaData;

        /**
         * Constructor for the Builder of CaptureScreenMetaData
         */
        public Builder() {
            captureScreenMetaData = new CaptureScreenMetaData();
        }

        /**
         * Building the {@link CaptureScreenMetaData} object based on the requested features
         *
         * @return the built {@link CaptureScreenMetaData} object
         */
        public CaptureScreenMetaData build() {
            return captureScreenMetaData;
        }

        /**
         * Enables the cancel capture button on the capturing screen
         *
         * @return {@link Builder} object
         */
        public Builder enableDefaultCancelButton() {
            captureScreenMetaData.setDefaultCancelButtonEnabled();
            return this;
        }

        /**
         * Sets a custom capturing screen title
         *
         * @param screenTitle custom title resource id for the capturing screen
         * @return {@link Builder} object
         */
        public Builder setScreenTitle(int screenTitle) {
            captureScreenMetaData.setTitleId(screenTitle);
            return this;
        }

        /**
         * Sets a custom capturing screen subtitle
         *
         * @param screenSubtitle custom subtitle resource id for the capturing screen
         * @return {@link Builder} object
         */
        public Builder setScreenSubtitle(int screenSubtitle) {
            captureScreenMetaData.setSubtitleId(screenSubtitle);
            return this;
        }

    }
}
