package io.digified.digified_library.capture.utils;

import android.graphics.Bitmap;
import android.util.Base64;

import java.io.ByteArrayOutputStream;

public class ImageConverter {

    private static final String TAG = "ImageConverter";

    public static final String PREFIX = "data:image/jpeg;base64,";

    private static final String NAME = "digified";
    private static final String PNG = ".png";

    //resizing without messing up the aspect ratio
    private static Bitmap getResizedBitmapIfNecessary(Bitmap image, int maxImageWidth, int maxImageHeight) {
        int width = image.getWidth();
        int height = image.getHeight();

//        Log.e(TAG, "getResizedBitmapIfNecessary: image.getWidth() = "
//                + image.getWidth() + ", image.getHeight() " + image.getHeight());
//
//        Log.e(TAG, "getResizedBitmapIfNecessary: maxImageWidth = "
//                + maxImageWidth + ", maxImageHeight " + maxImageHeight);

        if (width > maxImageWidth || height > maxImageHeight) {

            int scaledWidth = width;
            int scaledHeight = height;

            if (width > maxImageWidth) {
                scaledHeight = (height * maxImageWidth) / width;
                scaledWidth = maxImageWidth;
            }


//            Log.e(TAG, "getResizedBitmapIfNecessary: scaledBitmap.getWidth() = "
//                    + scaledWidth + ", scaledBitmap.getHeight() " +scaledHeight);

            if (scaledHeight > maxImageHeight) {
                scaledWidth = (scaledWidth * maxImageHeight) / scaledHeight;
                scaledHeight = maxImageHeight;
            }


            Bitmap scaledBitmap = Bitmap.createScaledBitmap(image, scaledWidth, scaledHeight, true);

//            Log.e(TAG, "getResizedBitmapIfNecessary: scaledBitmap.getWidth() = "
//                    + scaledBitmap.getWidth() + ", scaledBitmap.getHeight() " + scaledBitmap.getHeight());

            return scaledBitmap;

        } else {

//            Log.e(TAG, "getResizedBitmapIfNecessary: no scaling happened");
            return image;
        }

    }

    public static String imageToBase64(Bitmap bitmap, int maxImageWidth, int maxImageHeight) {
        Bitmap resizedBitmap = getResizedBitmapIfNecessary(bitmap, maxImageWidth, maxImageHeight);

        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        resizedBitmap.compress(Bitmap.CompressFormat.PNG, 0, byteArrayOutputStream); //bm is the bitmap object
        byte[] byteArrayImage = byteArrayOutputStream.toByteArray();
        String base64String = Base64.encodeToString(byteArrayImage, Base64.DEFAULT);
        String base64Fixed = base64String.replace("\n", "");
//        return PREFIX + base64Fixed;
        return base64Fixed;
    }

//    public static FloatBuffer bitmapToNormalizedFloatBufferBGR(Bitmap inputBitmap) {
//        int width = inputBitmap.getWidth();
//        int height = inputBitmap.getHeight();
//
//        FloatBuffer input = FloatBuffer.allocate(inputBitmap.getWidth() * inputBitmap.getHeight() * 3);
//        for (int y = 0; y < height; y++) {
//            for (int x = 0; x < width; x++) {
//                int px = inputBitmap.getPixel(x, y);
//
//                // Get channel values from the pixel value.
//                int r = Color.red(px);
//                int g = Color.green(px);
//                int b = Color.blue(px);
//
//
//                // Normalize channel values to [-1.0, 1.0]. This requirement depends
//                // on the model. For example, some models might require values to be
//                // normalized to the range [0.0, 1.0] instead.
//                float rf = (r) / 255.0f;
//                float gf = (g) / 255.0f;
//                float bf = (b) / 255.0f;
//
////                BGR
//                input.put(bf);
//                input.put(gf);
//                input.put(rf);
//
////                input.put(r);
////                input.put(g);
////                input.put(b);
//            }
//        }
//
//        input.rewind();
//
//        return input;
//    }
//
//    private static float mapTo(float a1, float a2, float b1, float b2, float s) {
//
////        [a1, a2] => [b1, b2]
////
////        if s in range of [a1, a2]
////
////        then t which will be in range of [b1, b2]
//        return b1 + ((s - a1) * (b2 - b1)) / (a2 - a1);
//    }

//    public static FloatBuffer bitmapToNormalizedFloatBufferRGB(Bitmap inputBitmap) {
//        int width = inputBitmap.getWidth();
//        int height = inputBitmap.getHeight();
//
//        FloatBuffer input = FloatBuffer.allocate(inputBitmap.getWidth() * inputBitmap.getHeight() * 3);
//        for (int y = 0; y < height; y++) {
//            for (int x = 0; x < width; x++) {
//                int px = inputBitmap.getPixel(x, y);
//
//                // Get channel values from the pixel value.
//                int r = Color.red(px);
//                int g = Color.green(px);
//                int b = Color.blue(px);
//
//
//                float rf = mapTo(0,
//                        255,
//                        -1,
//                        1,
//                        r);
//                float gf = mapTo(0,
//                        255,
//                        -1,
//                        1,
//                        g);
//                float bf = mapTo(0,
//                        255,
//                        -1,
//                        1,
//                        b);
//
////                RGB
//                input.put(rf);
//                input.put(gf);
//                input.put(bf);
//
////                input.put(r);
////                input.put(g);
////                input.put(b);
//            }
//        }
//
//        input.rewind();
//
//        return input;
//    }
//
//    public static File bitmapToFile(Context context, Bitmap bitmap, int maxImageWidth, int maxImageHeight) throws IOException {
//        Bitmap resizedBitmap = getResizedBitmapIfNecessary(bitmap, maxImageWidth, maxImageHeight);
//
//        //create a file to write bitmap data
//        File directory = context.getDir(NAME, Context.MODE_PRIVATE);
//        String fileName = NAME + System.currentTimeMillis() + PNG;
//
//        File file = new File(directory, fileName);
//        file.createNewFile();
//        file.deleteOnExit();
//
//        ByteArrayOutputStream bos = new ByteArrayOutputStream();
//        resizedBitmap.compress(Bitmap.CompressFormat.PNG, 100, bos);
////        resizedBitmap.compress(Bitmap.CompressFormat.PNG, 100, bos);
//        byte[] bitmapData = bos.toByteArray();
//
//        FileOutputStream fos = new FileOutputStream(file);
//        fos.write(bitmapData);
//        fos.flush();
//        fos.close();
//
//        return file;
//    }


//    public static YuvImage extractYUVImage(InputImage inputImage) {
//        ByteBuffer byteBuffer = inputImage.getByteBuffer();
//        byte[] imageBytes;
//        if (byteBuffer != null) {
//            imageBytes = new byte[byteBuffer.remaining()];
//
//            byteBuffer.get(imageBytes);
//
//            return new YuvImage(imageBytes,
//                    ImageFormat.NV21,
//                    inputImage.getWidth(),
//                    inputImage.getHeight(),
//                    null);
//        } else {
//            return null;
//        }
//    }

//    public static Bitmap convertYUVToRGBA(YuvImage yuvImage, @Nullable Rect cropRect) {
//        ByteArrayOutputStream baos = new ByteArrayOutputStream();
//        if (cropRect == null) {
//            cropRect = new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight());
//        }
//        yuvImage.compressToJpeg(cropRect, 100, baos);
//        byte[] jdata = baos.toByteArray();
//        return BitmapFactory.decodeByteArray(jdata, 0, jdata.length);
//    }


}
