package io.digified.digified_library.capture.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;

public class ImageHandler {

    private static final String TAG = "ImageHandler";

    public static Bitmap rotateImage(Bitmap bitmap, int degrees) {
        if (degrees == 0) return bitmap;

        Matrix mat = new Matrix();
        mat.postRotate(degrees);
        return Bitmap.createBitmap(bitmap,
                0,
                0,
                bitmap.getWidth(),
                bitmap.getHeight(),
                mat,
                true);
    }

    public static Rect getSquareCroppingRect(int width, int height, boolean isRotated) {
        if (isRotated) {
            int x = height / 2;
            int y = width / 2;

            int top = (int) (x - (height / 2.0f));
            int left = (int) (y - (height / 2.0f));
            int bottom = (int) (x + (height / 2.0f));
            int right = (int) (y + (height / 2.0f));

            return new Rect(left, top, right, bottom);
        } else {
            int x = width / 2;
            int y = height / 2;

            int left = (int) (x - (width / 2.0f));
            int top = (int) (y - (width / 2.0f));
            int right = (int) (x + (width / 2.0f));
            int bottom = (int) (y + (width / 2.0f));

            return new Rect(left, top, right, bottom);
        }
    }


    public static Bitmap cropImage(Bitmap bitmap, Rect rect) {
        int x = rect.left;
        int y = rect.top;
        int width = rect.width();
        int height = rect.height();

//        Log.e(TAG, "---------------------------------");
//        Log.e(TAG, "bitmap width = " + bitmap.getWidth() + " - bitmap height = " + bitmap.getHeight());
//        Log.e(TAG, "rect width = " + rect.width() + " - rect height = " + rect.height());
//        Log.e(TAG, "rect x = " + rect.left + " - rect y = " + rect.top);

        if (x < 0) x = 0;
        if (y < 0) y = 0;
        if (width < 0) width = bitmap.getWidth();
        if (height < 0) height = bitmap.getHeight();

        if (x + width > bitmap.getWidth()) {
//            Log.e(TAG, "x + width > bitmap.getWidth()");
            x = 0;
            width = bitmap.getWidth();
        }
        if (y + height > bitmap.getHeight()) {
//            Log.e(TAG, "y + height > bitmap.getHeight()");
            y = 0;
            height = bitmap.getHeight();
        }

//        Log.e(TAG, "cropping to: x = " + x + ", y = " + y + ", width = " + width + ", height = " + height);

        return Bitmap.createBitmap(bitmap, x, y, width, height);
    }

//    //best results so far
//    public static RectF adjustRectToScreen(float viewWidth,
//                                           float viewHeight,
//                                           float cameraPreviewWidth,
//                                           float cameraPreviewHeight,
//                                           Rect input,
//                                           boolean rotate) {
//
////        Log.e(TAG, "viewWidth = " + viewWidth);
////        Log.e(TAG, "viewHeight = " + viewHeight);
////        Log.e(TAG, "input rect width = " + input.width());
////        Log.e(TAG, "input rect height = " + input.height());
////        Log.e(TAG, "cameraPreviewWidth = " + cameraPreviewWidth);
////        Log.e(TAG, "cameraPreviewHeight = " + cameraPreviewHeight);
//
////        float heightPixels = 2071.0f;
////        float widthPixels = 1080.0f;
////        imageWidth = 720
////        imageHeight = 960
//
//        float margin = 0;
//
//        if (cameraPreviewWidth > cameraPreviewHeight) {
//            float temp = cameraPreviewWidth;
//            cameraPreviewWidth = cameraPreviewHeight;
//            cameraPreviewHeight = temp;
//            margin = (cameraPreviewHeight - cameraPreviewWidth) / 2;
//        }
//
//        float heightRatio = viewHeight / cameraPreviewHeight;
//        float widthRatio = viewWidth / cameraPreviewWidth;
////        float widthRatio = viewWidth / cameraPreviewHeight;
//
//
//        float left = (input.left * widthRatio) - margin;
//        float top = input.top * heightRatio;
//        float right = left + (input.width() * heightRatio);
//        float bottom = top + (input.height() * heightRatio);
//
//        RectF rectF = new RectF(left, top, right, bottom);
//
////        RectF rectF = new RectF(input.left, input.top, input.right, input.bottom);
//
////        Log.e(TAG, "rect = " + rectF.toShortString());
////        Log.e(TAG, "result rect width = " + rectF.width());
////        Log.e(TAG, "result rect height = " + rectF.height());
//
//        if (rotate) {
//            return rotateRect(rectF);
//        }
//
//
//        return rectF;
//    }


    private static RectF rotateRect(RectF rectF) {
        float x = rectF.centerX();
        float y = rectF.centerY();

//            float rTop = y - (x - left);
//            float rBottom = y + (x - left);
//
//            float rLeft = x - (y - top);
//            float rRight = x + (y - top);

        float rotatedLeft = x + (rectF.top - y);
        float rotatedTop = y - (rectF.right - x);

        float rotatedRight = x + (rectF.bottom - y);
        float rotatedBottom = y - (rectF.left - x);

        //        Log.e(TAG, "rotatedRectF = " + rotatedRectF.toShortString());

        return new RectF(rotatedLeft, rotatedTop, rotatedRight, rotatedBottom);
    }

//    public static Bitmap cropToSquare(Bitmap inputBitmap, int rotationDegrees) {
//        Bitmap bitmap;
//        if (rotationDegrees != 0) {
//            bitmap = rotateImage(inputBitmap, rotationDegrees);
//        } else {
//            bitmap = inputBitmap;
//        }
//
//        int x = bitmap.getWidth() / 2;
//        int y = bitmap.getHeight() / 2;
//
//        int width = bitmap.getWidth();
//
//        int left = (int) (x - (width / 2.0f));
//        int top = (int) (y - (width / 2.0f));
//        int right = (int) (x + (width / 2.0f));
//        int bottom = (int) (y + (width / 2.0f));
//
//        Rect croppingRectangle = new Rect(left, top, right, bottom);
//
//        return ImageHandler.cropImage(bitmap, croppingRectangle);
//    }


//    public static Bitmap cropToSquare(InputImage inputImage, int rotationDegrees) {
//        ByteBuffer byteBuffer = inputImage.getByteBuffer();
//        byte[] imageBytes;
//        if (byteBuffer != null) {
//            imageBytes = new byte[byteBuffer.remaining()];
//
//            byteBuffer.get(imageBytes);
//
//            YuvImage yuvimage = new YuvImage(imageBytes, ImageFormat.NV21, inputImage.getWidth(), inputImage.getHeight(), null);
//            ByteArrayOutputStream baos = new ByteArrayOutputStream();
//            yuvimage.compressToJpeg(new Rect(0, 0, inputImage.getWidth(), inputImage.getHeight()), 100, baos);
//            byte[] jdata = baos.toByteArray();
//            Bitmap bitmap;
//
//            if (rotationDegrees != 0) {
//                Bitmap temp = BitmapFactory.decodeByteArray(jdata, 0, jdata.length);
//                bitmap = rotateImage(temp, rotationDegrees);
//            } else {
//                bitmap = BitmapFactory.decodeByteArray(jdata, 0, jdata.length);
//            }
//
//            int x = bitmap.getWidth() / 2;
//            int y = bitmap.getHeight() / 2;
//
//            int width = bitmap.getWidth();
//
//            int left = (int) (x - (width / 2.0f));
//            int top = (int) (y - (width / 2.0f));
//            int right = (int) (x + (width / 2.0f));
//            int bottom = (int) (y + (width / 2.0f));
//
//            Rect croppingRectangle = new Rect(left, top, right, bottom);
//
//            Bitmap croppedBitmap = ImageHandler.cropImage(bitmap, croppingRectangle);
//
////            Log.e(TAG, "bitmap width = " + croppedBitmap.getWidth());
////            Log.e(TAG, "bitmap height = " + croppedBitmap.getHeight());
//
//            return croppedBitmap;
//
////            return InputImage.fromBitmap(croppedBitmap, inputImage.getRotationDegrees());
//        } else {
//            return null;
//        }
//    }

//    public static Bitmap cropImage(View view,
//                                   Bitmap bitmap,
//                                   ImageView markerImageView) {
//
//
//        int rectHeightPX = markerImageView.getHeight();
//        int rectWidthPX = markerImageView.getWidth();
//
//        int imageWidth = bitmap.getWidth();
//        int imageHeight = bitmap.getHeight();
//
//        int frameHeight = view.getHeight();
//        int frameWidth = (imageWidth * frameHeight) / imageHeight;
//
//
//        int rectWidthNew = (rectWidthPX * imageWidth) / frameWidth;
//        int rectHeightNew = (rectHeightPX * imageHeight) / frameHeight;
//
//        int x = (imageWidth / 2) - (rectWidthNew / 2);
//        int y = (imageHeight / 2) - (rectHeightNew / 2);
//
//
//        Rect rect = new Rect(x, y, rectWidthNew + x, rectHeightNew + y);
//        return cropImage(bitmap, rect);
////        return Bitmap.createBitmap(bitmap, x, y, rectWidthNew, rectHeightNew);
//    }


}
