package io.digified.digified_library.capture.v2.detectors;

import android.content.Context;
import android.graphics.Bitmap;

import com.google.android.gms.tasks.Task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseDetector <T>{ //<T extends BaseDetectorResult>

    protected File loadModel(Context context, String modelFileName) throws IOException {
        File cacheFile = new File(context.getCacheDir(), modelFileName);

        try (InputStream inputStream = context.getAssets().open(modelFileName)) {
            try (FileOutputStream outputStream = new FileOutputStream(cacheFile)) {
                byte[] buf = new byte[1024];
                int len;
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
            }
        }
        return cacheFile;
    }

    public abstract Task<T> process(Bitmap image);

    public abstract void close();
}
