package io.digified.digified_library.capture.v2.detectors.manual_detector;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;

import io.digified.digified_library.capture.v2.detectors.BaseDetectionSelector;
import io.digified.digified_library.capture.v2.detectors.DetectorInterface;
import io.digified.digified_library.capture.v2.detectors.manual_detector.core.ManualDetectedImage;
import io.digified.digified_library.capture.v2.detectors.manual_detector.core.ManualDetectorConstants;
import io.digified.digified_library.capture.v2.detectors.modules.BaseSelected;

public class ManualImageSelector extends BaseDetectionSelector<ManualDetectedImage> {


    private static final float RECTANGLE_FACTOR_WIDTH = 0.2f;
    private static final float RECTANGLE_FACTOR_HEIGHT = 0.2f;

    public ManualImageSelector(int desiredWidth, int desiredHeight, int numberOfImages, DetectorInterface detectorInterface) {
        super(desiredWidth, desiredHeight, numberOfImages, detectorInterface);
    }


    @Override
    public void check(ManualDetectedImage moduleResults, Bitmap cameraBitmap) {
        super.check(moduleResults, cameraBitmap);
        if (isCaptureDelayDone()) {

            if (moduleResults != null) {
                Rect croppingRect = moduleResults.getCroppingRect();
                Rect scaledRect;

                if (croppingRect != null && croppingRect.width() != 0 && croppingRect.height() != 0) {

                    if (moduleResults.getMode() == ManualDetectorConstants.Mode.SMALL_AREA) {
                        scaledRect = getScaledRect(croppingRect, RECTANGLE_FACTOR_WIDTH, RECTANGLE_FACTOR_HEIGHT);
                    } else {
                        scaledRect = croppingRect;
                    }

                    if (prepareForCapturing()) {

                        SelectedGeneric selectedGeneric = new SelectedGeneric(moduleResults.getInputModelImage(), scaledRect, null);

                        boolean capturingDone = capture(selectedGeneric);

                        if (capturingDone) {
//                    cropToDetectionAndSend(selectedGeneric);
                            cropToDetectionAndSend();
                        } else {
                        }
                    }
                }
            }
        }

    }


    @Override
    protected BaseSelected selectBestDetection() {
        return null;
    }

}

