package io.digified.digified_library.capture.v2.detectors.manual_detector.core;

import android.graphics.Bitmap;
import android.graphics.Rect;

import io.digified.digified_library.capture.v2.detectors.modules.BaseDetectorResult;

public class ManualDetectedImage extends BaseDetectorResult {

    private final int mode;
    private final Bitmap inputModelImage;
    private final Rect croppingRect;


    public ManualDetectedImage(Rect croppingRect, int mode, Bitmap inputModelImage) {
        this.mode = mode;
        this.inputModelImage = inputModelImage;
        this.croppingRect = croppingRect;
    }

    public static ManualDetectedImage emptyResult(int mode) {
        return new ManualDetectedImage(new Rect(0, 0, 0, 0), mode, null);
    }

    public Rect getCroppingRect() {
        return croppingRect;
    }

    public int getMode() {
        return mode;
    }

    public Bitmap getInputModelImage() {
        return inputModelImage;
    }
}
