package io.digified.digified_library.capture.v2.detectors.manual_detector.core;

import android.graphics.Bitmap;
import android.graphics.Rect;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

import io.digified.digified_library.capture.utils.ImageHandler;
import io.digified.digified_library.capture.v2.detectors.BaseDetector;

public class ManualImageDetector extends BaseDetector<ManualDetectedImage> {

    private static final String TAG = "ManualImageDetector";

    private static final int FRONT_ROTATION = 0;
    private static final int BACK_ROTATION = 0;

    private final int mode;
    private final int desiredWidth;
    private final int desiredHeight;
    private boolean shouldCapture;
    private final int rotationAngle;


    public ManualImageDetector(int desiredWidth, int desiredHeight, int mode, boolean isFrontCamera) {
        this.mode = mode;
        this.desiredWidth = desiredWidth;
        this.desiredHeight = desiredHeight;
        rotationAngle = isFrontCamera ? FRONT_ROTATION : BACK_ROTATION;
        shouldCapture = false;
    }

    @Override
    public Task<ManualDetectedImage> process(Bitmap image) {
        TaskCompletionSource<ManualDetectedImage> task = new TaskCompletionSource<>();
        task.setResult(capture(image));
        return task.getTask();
    }

    @Override
    public void close() {

    }

    private ManualDetectedImage capture(Bitmap image) {

        if (!shouldCapture) return ManualDetectedImage.emptyResult(mode);

        if (image == null) return ManualDetectedImage.emptyResult(mode);

        Bitmap rotatedImageBitmap = ImageHandler.rotateImage(image, rotationAngle);

        if (rotatedImageBitmap == null) return ManualDetectedImage.emptyResult(mode);

        Rect croppingRect = buildCroppingRect(rotatedImageBitmap);

        return new ManualDetectedImage(croppingRect, mode, rotatedImageBitmap);

    }

    private Rect buildCroppingRect(Bitmap rotatedImageBitmap) {
        int centerX = rotatedImageBitmap.getWidth() / 2;
        int centerY = rotatedImageBitmap.getHeight() / 2;

        int left = centerX - desiredWidth / 2;
        int right = centerX + desiredWidth / 2;
        int top = centerY - desiredHeight / 2;
        int bottom = centerY + desiredHeight / 2;

        return new Rect(left, top, right, bottom);
    }

    public void capture() {
        shouldCapture = true;
    }


}
