package io.digified.digified_library.capture.v2.display;

import io.digified.digified_library.capture.CaptureScreenMetaData;

class DisplayModel {

    static final class DisplayType {
        static final int DOCUMENT_SMALL = 1;
        static final int SELFIE = 2;
//        static final int DOCUMENT_LARGE = 2;

    }

    private int titleId;
    private int subtitleId;
    private final int displayType;
    private final boolean shouldUseML;

    private boolean enableCancelButton;

    public DisplayModel(int titleId,
                        int subtitleId,
                        int displayType,
                        boolean enableCancelButton,
                        boolean shouldUseML) {
        this.titleId = titleId;
        this.subtitleId = subtitleId;
        this.displayType = displayType;
        this.enableCancelButton = enableCancelButton;
        this.shouldUseML = shouldUseML;
    }

    public void overrideWithMetaData(CaptureScreenMetaData captureScreenMetaData) {
        if (captureScreenMetaData == null) return;

        if (captureScreenMetaData.getTitleId() != null) {
            titleId = captureScreenMetaData.getTitleId();
        }

        if (captureScreenMetaData.getSubTitleId() != null) {
            subtitleId = captureScreenMetaData.getSubTitleId();
        }

        enableCancelButton = captureScreenMetaData.isDefaultCancelButtonEnabled();
    }

    public int getTitleId() {
        return titleId;
    }

    public int getSubtitleId() {
        return subtitleId;
    }

    public int getDisplayType() {
        return displayType;
    }

    public boolean isShouldUseML() {
        return shouldUseML;
    }

    public boolean isCancelButtonEnabled() {
        return enableCancelButton;
    }
}
