package io.digified.digified_library.capture.v2.display;


import android.app.Activity;

import io.digified.digified_library.capture.v2.detectors.DetectorInterface;
import io.digified.digified_library.capture.v2.detectors.VisionProcessorBase;
import io.digified.digified_library.capture.v2.detectors.manual_detector.ManualDetectorProcessor;
import io.digified.digified_library.capture.v2.detectors.manual_detector.core.ManualDetectorConstants;

abstract class MainFrameProcessorSelector {

    VisionProcessorBase<?> getIdFrontFrameProcessor(Activity activity,
                                                           int desiredWidth,
                                                           int desiredHeight,
                                                           int imageCount,
                                                           boolean shouldUseMl,
                                                           DetectorInterface detectorInterface) {

        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                false,
                detectorInterface);
    }

    VisionProcessorBase<?> getIdBackFrameProcessor(Activity activity,
                                                          int desiredWidth,
                                                          int desiredHeight,
                                                          int imageCount,
                                                          boolean shouldUseMl,
                                                          DetectorInterface detectorInterface) {


        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                false,
                detectorInterface);
    }

    VisionProcessorBase<?> getSelfieFrameProcessor(Activity activity,
                                                          int desiredWidth,
                                                          int desiredHeight,
                                                          int imageCount,
                                                          boolean shouldUseMl,
                                                          DetectorInterface detectorInterface) {

        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                true,
                detectorInterface);
    }

    VisionProcessorBase<?> getVehicleLicenseFrontFrameProcessor(Activity activity,
                                                                       int desiredWidth,
                                                                       int desiredHeight,
                                                                       int imageCount,
                                                                       boolean shouldUseMl,
                                                                       DetectorInterface detectorInterface) {

        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                false,
                detectorInterface);
    }

    VisionProcessorBase<?> getVehicleLicenseBackFrameProcessor(Activity activity,
                                                                      int desiredWidth,
                                                                      int desiredHeight,
                                                                      int imageCount,
                                                                      boolean shouldUseMl,
                                                                      DetectorInterface detectorInterface) {

        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                false,
                detectorInterface);
    }

    VisionProcessorBase<?> getIdGenericFrontFrameProcessor(Activity activity,
                                                                  int desiredWidth,
                                                                  int desiredHeight,
                                                                  int imageCount,
                                                                  boolean shouldUseMl,
                                                                  DetectorInterface detectorInterface) {

        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                false,
                detectorInterface);
    }

    VisionProcessorBase<?> getIdGenericBackFrameProcessor(Activity activity,
                                                                 int desiredWidth,
                                                                 int desiredHeight,
                                                                 int imageCount,
                                                                 boolean shouldUseMl,
                                                                 DetectorInterface detectorInterface) {

        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                false,
                detectorInterface);
    }

    VisionProcessorBase<?> getPassportFrameProcessor(Activity activity,
                                                            int desiredWidth,
                                                            int desiredHeight,
                                                            int imageCount,
                                                            boolean shouldUseMl,
                                                            DetectorInterface detectorInterface) {

        return new ManualDetectorProcessor(activity,
                desiredWidth,
                desiredHeight,
                imageCount,
                ManualDetectorConstants.Mode.SMALL_AREA,
                false,
                detectorInterface);
    }

}
