package io.digified.digified_library.api;


public final class ApiConstants {


    public static final class Url {
        public static final String BASE_URL = "https://ekyc2.digified.io/";
        public static final String INIT_REQUEST = "init";
        public static final String EXTRACT_REQUEST = "extract";
        public static final String FRAUD_REQUEST = "id_check";
        public static final String FACE_MATCHING_REQUEST = "match";
        public static final String TRANSLITERATE = "transliterate";

        public static final String RESULTS = "results";
        public static final String API_VERSION = "1.6";
    }

    public static final class ParamsKeys {
        public static final String API_KEY = "api_key";
        public static final String API_VERSION = "api_ver";
        public static final String WARNING_ACTION = "warn_action";
        public static final String USER_NAME = "username";
        public static final String PHONE = "phone";
        public static final String EMAIL = "email";
        public static final String FORMAT = "format";
        public static final String DOCUMENT = "document";
        public static final String FRONT = "front";
        public static final String BACK = "back";
        public static final String TOKEN = "token";
        public static final String PREVIOUS = "previous";
        public static final String SELFIE = "selfie";
        public static final String FRAME_1 = "frame_1";
        public static final String FRAME_2 = "frame_2";
        public static final String FRAME_3 = "frame_3";

        public static final String ID_FACE = "id_face";

        public static final String FIRST_NAME = "first-name";
        public static final String FAMILY_NAME = "familyName";
        public static final String ADDRESS_LINE_1 = "address-line-1";
        public static final String SERIAL_NUMBER = "serialNumber";
        public static final String DISTRICT = "district";
        public static final String GOVERNORATE = "governorate";
        public static final String FRONT_ID = "front-id";
        public static final String JOB = "job";
        public static final String GENDER = "gender";
        public static final String RELIGION = "religion";
        public static final String MARTIAL_STATUS = "martial-status";
        public static final String EXPIRY_DATE = "expiryDate";
        public static final String BACK_ID = "back-id";
    }

    public static final class ContentType {
        public static final String TEXT_PLAIN = "text/plain";
        public static final String IMAGE_ = "image/*";
    }

    public static final class FileFormat {
        public static final String BASE64 = "base64";
        public static final String MULTIPART = "multipart";
    }

    public static final class DocumentType {
        public static final String EGYPTIAN_ID = "egyID";
        public static final String GENERIC_ID = "KenID";
        public static final String VEHICLE_LICENSE = "CarLicense";
    }

    public static final class Process {
        public static final String INITIALIZE = "initialize";
        public static final String EXTRACT = "extract";
        public static final String MATCH = "match";
        public static final String TRANSLITERATE = "transliterate";
        public static final String DONE = "";
    }

    public static final class OverAllStatus {
        public static final int FAILED = 0;
        public static final int VERIFIED = 1;
        public static final int IN_PROGRESS = 2;
        public static final int PENDING = 3;
    }
}
