package io.digified.digified_library.api.callbacks;

import io.digified.digified_library.api.result.BaseDigifiedResult;
import io.digified.digified_library.errors.DigifiedError;
import io.digified.digified_library.errors.ErrorConstants;

public interface DigifiedCallback<T extends BaseDigifiedResult> {

    /**
     * This method is called when the API request was successful and we have the response
     *
     * @param result the result from the API request of type {@link T} that extends {@link BaseDigifiedResult}
     */
    void onResult(T result);

    /**
     * This method is called when there is a problem with the API call
     *
     * @param digifiedError the error that caused the request to fail
     *                      (you can find error codes here {@link ErrorConstants})
     */
    void onFailure(DigifiedError digifiedError);

}
