package io.digified.digified_library.api.network;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class ProgressRequestBody extends RequestBody {

    private static final String TAG = "ProgressRequestBody";

    private static final int DEFAULT_BUFFER_SIZE = 2048;

    private final ProgressUpdater progressUpdater;
    private final String contentType;
    private final String base64;

    public ProgressRequestBody(final String base64, String contentType, ProgressUpdater progressUpdater) {
        this.contentType = contentType;
        this.base64 = base64;
        this.progressUpdater = progressUpdater;
        progressUpdater.addFile(base64.length());
    }


    @Override
    public MediaType contentType() {
        return MediaType.parse(contentType);
    }

    @Override
    public long contentLength() {
        return base64.length();
    }


    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];

        try (ByteArrayInputStream in = new ByteArrayInputStream(base64.getBytes())) {
            long uploaded = 0;
            int read;


            while ((read = in.read(buffer)) != -1) {
                // update progress on UI thread
                progressUpdater.setCurrentProgress(uploaded);

                uploaded += read;
                sink.write(buffer, 0, read);
            }
        }
    }


}


