package io.digified.digified_library.api.result;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;

public abstract class DigifiedResult extends BaseDigifiedResult{

    @SerializedName("msg")
    private String message;

    @SerializedName("next")
    private String nextProcess;

    @SerializedName("overall_status")
    private Integer overallStatus;

    @SerializedName("result")
    private Integer result;

    @SerializedName("should_terminate")
    private Boolean shouldTerminate;

    @SerializedName("Error")
    private String error;

    @SerializedName("code")
    private ArrayList<String> errorCode;

//    /**
//     * Constructor for the DigifiedResult
//     *
//     * @param message         "msg" in the API response, represents the recommended action for user
//     * @param nextProcess     "next" in the API response, represents the next operation
//     * @param overallStatus   "overall_status" in the API response,
//     *                        Enumeration representing overall status of the session:
//     *                        (FAILED: 0, VERIFIED: 1, IN_PROGRESS: 2, PENDING: 3)
//     * @param result          "result" in the API response,
//     *                        indicating the session status: (SUCCESS: 0, HAS_ERRORS: -1, HAS_WARNINGS: 1)
//     * @param shouldTerminate "should_terminate" in the API response,
//     *                        False if there will be a next op-state / try, True otherwise
//     * @param error           "Error" in the API response, the error message
//     * @param errorCode       "code" in the API response, the error code
//     */
//    public DigifiedResult(String message,
//                          String nextProcess,
//                          Integer overallStatus,
//                          Integer result,
//                          Boolean shouldTerminate,
//                          String error,
//                          ArrayList<String> errorCode) {
//        this.message = message;
//        this.nextProcess = nextProcess;
//        this.overallStatus = overallStatus;
//        this.result = result;
//        this.shouldTerminate = shouldTerminate;
//        this.error = error;
//        this.errorCode = errorCode;
//    }

    /**
     * Getter method for {@link #message}: represents the recommended action for user
     *
     * @return "msg" in the API response
     */
    public String getMessage() {
        return message;
    }

    /**
     * Getter method for {@link #nextProcess}: represents the next operation
     *
     * @return "next" in the API response
     */
    public String getNextProcess() {
        return nextProcess;
    }

    /**
     * Getter method for {@link #overallStatus}: Enumeration representing overall status of the session:
     * (FAILED: 0, VERIFIED: 1, IN_PROGRESS: 2, PENDING: 3)
     *
     * @return "overall_status" in the API response
     */
    public Integer getOverallStatus() {
        return overallStatus;
    }

    /**
     * Getter method for {@link #result}: indicating the session status: (SUCCESS: 0, HAS_ERRORS: -1, HAS_WARNINGS: 1)
     *
     * @return "result" in the API response
     */
    public Integer getResult() {
        return result;
    }

    /**
     * Getter method for {@link #shouldTerminate}: False if there will be a next op-state / try, True otherwise.
     *
     * @return "should_terminate" in the API response
     */
    public Boolean getShouldTerminate() {
        return shouldTerminate;
    }

    /**
     * Getter method for {@link #error}: the error message
     *
     * @return "Error" in the API response
     */
    public String getError() {
        return error;
    }

    /**
     * Getter method for {@link #errorCode}: the error code
     *
     * @return "code" in the API response
     */
    public ArrayList<String> getErrorCode() {
        return errorCode;
    }
}
