package io.digified.digified_library.api.result;

import com.google.gson.annotations.SerializedName;

public class FaceMatchResult extends DigifiedResult {

    @SerializedName("congruence")
    private Float congruence;

    @SerializedName("liveness")
    private Float liveness;

//    /**
//     * Response of the "Face Matching request" of the API
//     * Constructor for FaceMatchResult
//     *
//     * @param message         "msg" in the API response, represents the recommended action for user
//     * @param nextProcess     "next" in the API response, represents the next operation
//     * @param overallStatus   "overall_status" in the API response,
//     *                        Enumeration representing overall status of the session:
//     *                        (FAILED: 0, VERIFIED: 1, IN_PROGRESS: 2, PENDING: 3)
//     * @param result          "result" in the API response,
//     *                        indicating the session status: (SUCCESS: 0, HAS_ERRORS: -1, HAS_WARNINGS: 1)
//     * @param shouldTerminate "should_terminate" in the API response,
//     *                        False if there will be a next op-state / try, True otherwise
//     * @param error           "Error" in the API response, the error message
//     * @param errorCode       "code" in the API response, the error code
//     * @param congruence      "congruence" in the API response,
//     *                        How the two images match (the higher is the better) (value between 0-1).
//     * @param liveness        "liveness" in the API response,
//     *                        Detecting the confidence of how much is the selfie is real and not spoofed
//     *                        (the higher is the better) (value between 0-1).
//     */
//    public FaceMatchResult(String message,
//                           String nextProcess,
//                           Integer overallStatus,
//                           Integer result,
//                           Boolean shouldTerminate,
//                           String error,
//                           ArrayList<String> errorCode,
//                           Float congruence,
//                           Float liveness) {
//        super(message, nextProcess, overallStatus, result, shouldTerminate, error, errorCode);
//        this.congruence = congruence;
//        this.liveness = liveness;
//    }

    /**
     * Getter method for {@link #congruence}: How the two images match (the higher is the better)
     * (value between 0-1).
     *
     * @return "congruence" in the API response
     */
    public Float getCongruence() {
        return congruence;
    }

    /**
     * Getter method for {@link #liveness}: Detecting the confidence of how much is the selfie
     * is real and not spoofed (the higher is the better) (value between 0-1).
     *
     * @return "liveness" in the API response
     */
    public Float getLiveness() {
        return liveness;
    }
}
