package io.digified.digified_library.api.result;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;

import io.digified.digified_library.api.result.internal.id.BackIdData;
import io.digified.digified_library.api.result.internal.id.FrontIdData;


public class IdExtractionResult extends DigifiedResult {

    @SerializedName("front")
    private FrontIdData frontIdData;

    @SerializedName("back")
    private BackIdData backIdData;

    @SerializedName("front_liveness")
    private Float frontLiveness;

    @SerializedName("back_liveness")
    private Float backLiveness;

    @SerializedName("warning")
    private String warning;

    @SerializedName("warning_code")
    private ArrayList<String> warningCode;

//    /**
//     * Response of the "Extract request" of the API
//     * Constructor for IdExtractionResult
//     *
//     * @param message         "msg" in the API response, represents the recommended action for user
//     * @param nextProcess     "next" in the API response, represents the next operation
//     * @param overallStatus   "overall_status" in the API response,
//     *                        Enumeration representing overall status of the session:
//     *                        (FAILED: 0, VERIFIED: 1, IN_PROGRESS: 2, PENDING: 3)
//     * @param result          "result" in the API response,
//     *                        indicating the session status: (SUCCESS: 0, HAS_ERRORS: -1, HAS_WARNINGS: 1)
//     * @param shouldTerminate "should_terminate" in the API response,
//     *                        False if there will be a next op-state / try, True otherwise
//     * @param frontIdData     "front" in the API response, data of the front side of the id
//     * @param backIdData      "back" in the API response, data of the back side of the id
//     * @param error           "Error" in the API response, the error message
//     * @param errorCode       "code" in the API response, the error code
//     * @param warning         "warning" in the API response, the warning message
//     * @param warningCode     "warning_code" in the API response, the warning code
//     */
//    public IdExtractionResult(String message,
//                              String nextProcess,
//                              Integer overallStatus,
//                              Integer result,
//                              Boolean shouldTerminate,
//                              FrontIdData frontIdData,
//                              BackIdData backIdData,
//                              String error,
//                              ArrayList<String> errorCode,
//                              String warning,
//                              ArrayList<String> warningCode) {
//        super(message, nextProcess, overallStatus, result, shouldTerminate, error, errorCode);
//        this.frontIdData = frontIdData;
//        this.backIdData = backIdData;
//        this.warning = warning;
//        this.warningCode = warningCode;
//    }

    /**
     * Getter method for {@link #frontIdData}: data of the front side of the id
     *
     * @return "front" in the API response
     */
    public FrontIdData getFrontIdData() {
        return frontIdData;
    }

    /**
     * Getter method for {@link #backIdData}: data of the back side of the id
     *
     * @return "back" in the API response
     */
    public BackIdData getBackIdData() {
        return backIdData;
    }

    /**
     * Getter method for {@link #warning}: the warning message
     *
     * @return "warning" in the API response
     */
    public String getWarning() {
        return warning;
    }

    /**
     * Getter method for {@link #warningCode}: the warning code
     *
     * @return "warning_code" in the API response
     */
    public ArrayList<String> getWarningCode() {
        return warningCode;
    }

    /**
     * Getter method for {@link #frontLiveness}: the liveness score of the front image of the ID
     *
     * @return "front_liveness" in the API response
     */
    public Float getFrontLiveness() {
        return frontLiveness;
    }

    /**
     * Getter method for {@link #backLiveness}: the liveness score of the back image of the ID
     *
     * @return "back_liveness" in the API response
     */
    public Float getBackLiveness() {
        return backLiveness;
    }
}
