package io.digified.digified_library.api.result.internal.id;

import com.google.gson.annotations.SerializedName;

public class FrontIdData extends IdData {

    @SerializedName("name")
    private String name;

    @SerializedName("family_name")
    private String familyName;

    @SerializedName("address")
    private String address;

    @SerializedName("address_details")
    private String addressDetails;

    @SerializedName("street")
    private String street;

    @SerializedName("subdistrict")
    private String subDistrict;

    @SerializedName("district")
    private String district;

    @SerializedName("governorate")
    private String governorate;

    @SerializedName("serial")
    private String serialNumber;

    @SerializedName("birthdate")
    private String birthdate;

    @SerializedName("face_image")
    private String faceImageUrl;

    @SerializedName("birth_gov")
    private String birthGovernorate;


//    /**
//     * Constructor for FrontIdData
//     *
//     * @param nationalId     "national_id" in the API response, 14 digits integer representing the ID number
//     * @param imageUrl       "image" in the API response, URL link to cropped front ID
//     * @param name           "name" in the API response, first name
//     * @param familyName     "family_name" in the API response, represents the second name to family name
//     * @param address        "address" in the API response, representing the full address
//     * @param addressDetails "address_details" in the API response, representing the address details
//     *                       (house number, street name, ...)
//     * @param street         "street" in the API response, representing the street
//     * @param subDistrict    "subdistrict" in the API response, representing the subdistrict
//     * @param district       "district" in the API response, representing the district
//     * @param governorate    "governorate" in the API response, representing the governorate
//     * @param serialNumber   "serial" in the API response, represents the serial number of the ID
//     * @param birthdate      "birthdate" in the API response, the date of birth
//     * @param faceImageUrl   "face_image" in the API response, URL link to image
//     */
//    public FrontIdData(Long nationalId,
//                       String imageUrl,
//                       String name,
//                       String familyName,
//                       String address,
//                       String addressDetails,
//                       String street,
//                       String subDistrict,
//                       String district,
//                       String governorate,
//                       String serialNumber,
//                       String birthdate,
//                       String faceImageUrl) {
//        super(nationalId, imageUrl);
//        this.name = name;
//        this.familyName = familyName;
//        this.address = address;
//        this.addressDetails = addressDetails;
//        this.street = street;
//        this.subDistrict = subDistrict;
//        this.district = district;
//        this.governorate = governorate;
//        this.serialNumber = serialNumber;
//        this.birthdate = birthdate;
//        this.faceImageUrl = faceImageUrl;
//    }

    /**
     * Getter method for {@link #name}: first name
     *
     * @return "name" in the API response
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for {@link #familyName}: represents the second name to family name
     *
     * @return "family_name" in the API response
     */
    public String getFamilyName() {
        return familyName;
    }

    /**
     * Getter method for {@link #address}: representing the full address
     *
     * @return "address" in the API response
     */
    public String getAddress() {
        return address;
    }

    /**
     * Getter method for {@link #addressDetails}: representing the address details
     * (house number, street name, ...)
     *
     * @return "address_details" in the API response
     */
    public String getAddressDetails() {
        return addressDetails;
    }

    /**
     * Getter method for {@link #street}: representing the street
     *
     * @return "street" in the API response
     */
    public String getStreet() {
        return street;
    }

    /**
     * Getter method for {@link #subDistrict}: representing the subdistrict
     *
     * @return "subdistrict" in the API response
     */
    public String getSubDistrict() {
        return subDistrict;
    }

    /**
     * Getter method for {@link #district}: representing the district
     *
     * @return "district" in the API response
     */
    public String getDistrict() {
        return district;
    }

    /**
     * Getter method for {@link #governorate}: representing the governorate
     *
     * @return "governorate" in the API response
     */
    public String getGovernorate() {
        return governorate;
    }

    /**
     * Getter method for {@link #serialNumber}: represents the serial number of the ID
     *
     * @return "serial" in the API response
     */
    public String getSerialNumber() {
        return serialNumber;
    }

    /**
     * Getter method for {@link #birthdate}: the date of birth
     *
     * @return "birthdate" in the API response
     */
    public String getBirthdate() {
        return birthdate;
    }

    /**
     * Getter method for {@link #faceImageUrl}: URL link to image
     *
     * @return "face_image" in the API response
     */
    public String getFaceImageUrl() {
        return faceImageUrl;
    }

    /**
     * Getter method for {@link #birthGovernorate}: the birth governorate of the ID owner
     *
     * @return "birth_gov" in the API response
     */
    public String getBirthGovernorate() {
        return birthGovernorate;
    }
}
