package io.digified.digified_library.api.result.internal.id;

import com.google.gson.annotations.SerializedName;

import io.digified.digified_library.api.result.BaseDocumentSide;

public abstract class IdData extends BaseDocumentSide {


    @SerializedName("national_id")
    private Long nationalId;

    @SerializedName("image")
    private String imageUrl;

//    /**
//     * Constructor of IdData
//     *
//     * @param nationalId "national_id" in the API response, 14 digits integer representing the ID number
//     * @param imageUrl   "image" in the API response, URL link to cropped front ID or back ID
//     */
//    public IdData(Long nationalId, String imageUrl) {
//        this.nationalId = nationalId;
//        this.imageUrl = imageUrl;
//    }

    /**
     * Getter method for {@link #nationalId}: 14 digits integer representing the ID number
     *
     * @return "national_id" in the API response
     */
    public Long getNationalId() {
        return nationalId;
    }

    /**
     * Getter method for {@link #imageUrl}: URL link to cropped front ID or back ID
     *
     * @return "image" in the API response
     */
    public String getImageUrl() {
        return imageUrl;
    }
}
