package io.digified.digified_library.api.result.internal.passport;

import com.google.gson.annotations.SerializedName;

import io.digified.digified_library.api.result.BaseDocumentSide;

public class PassportData extends BaseDocumentSide {

    @SerializedName("Country")
    private String country;

    @SerializedName("Place_of_Birth")
    private String birthPlace;

    @SerializedName("Place_of_Issue")
    private String issuePlace;

    @SerializedName("birthdate")
    private String birthdate;

    @SerializedName("documentAdditionalNumber")
    private String documentAdditionalNumber;

    @SerializedName("expiration")
    private String expirationDate;

    @SerializedName("first_name")
    private String firstName;

    @SerializedName("gender")
    private String gender;

    @SerializedName("image")
    private String imageUrl;

    @SerializedName("isoNumericCountryCode")
    private String isoNumericCountryCode;

    @SerializedName("issue_date")
    private String issueDate;

    @SerializedName("last_name")
    private String lastName;

    @SerializedName("nationality")
    private String nationality;

    @SerializedName("serial")
    private String serial;

    @SerializedName("address")
    private String address;

    /**
     * Getter method for Country
     *
     * @return "Country" in the API response
     */
    public String getCountry() {
        return country;
    }

    /**
     * Getter method for Birth place
     *
     * @return "Place_of_Birth" in the API response
     */
    public String getBirthPlace() {
        return birthPlace;
    }

    /**
     * Getter method for code of the issuance place of the passport
     *
     * @return "Place_of_Issue" in the API response
     */
    public String getIssuePlace() {
        return issuePlace;
    }

    /**
     * Getter method for birthdate written in the passport
     *
     * @return "birthdate" in the API response
     */
    public String getBirthdate() {
        return birthdate;
    }

    /**
     * Getter method for document additional number
     *
     * @return "documentAdditionalNumber" in the API response
     */
    public String getDocumentAdditionalNumber() {
        return documentAdditionalNumber;
    }

    /**
     * Getter method for expiration date of the passport
     *
     * @return "expiration" in the API response
     */
    public String getExpirationDate() {
        return expirationDate;
    }

    /**
     * Getter method for first name in the passport
     *
     * @return "first_name" in the API response
     */
    public String getFirstName() {
        return firstName;
    }

    /**
     * Getter method for gender in the passport
     *
     * @return "gender" in the API response
     */
    public String getGender() {
        return gender;
    }

    /**
     * Getter method for a cropped image of the passport
     *
     * @return "image" in the API response
     */
    public String getImageUrl() {
        return imageUrl;
    }

    /**
     * Getter method for iso country code
     *
     * @return "isoNumericCountryCode" in the API response
     */
    public String getIsoNumericCountryCode() {
        return isoNumericCountryCode;
    }


    /**
     * Getter method for the issue date of the passport
     *
     * @return "issue_date" in the API response
     */
    public String getIssueDate() {
        return issueDate;
    }

    /**
     * Getter method for last name in the passport
     *
     * @return "last_name" in the API response
     */
    public String getLastName() {
        return lastName;
    }

    /**
     * Getter method for nationality in the passport
     *
     * @return "nationality" in the API response
     */
    public String getNationality() {
        return nationality;
    }

    /**
     * Getter method for passport serial number
     *
     * @return "serial" in the API response
     */
    public String getSerial() {
        return serial;
    }

    /**
     * Getter method for passport address
     *
     * @return "address" in the API response
     */
    public String getAddress() {
        return address;
    }
}
