package io.digified.digified_library.api.result.internal.vehicle_license;

import com.google.gson.annotations.SerializedName;

public class BackVehicleLicenseData extends VehicleLicenseData {

    @SerializedName("brand")
    private String brand;

    @SerializedName("chassis_num")
    private String chassisNumber;

    @SerializedName("color")
    private String color;

    @SerializedName("cylinders")
    private String cylinders;

    @SerializedName("engine_capacity")
    private String engineCapacity;

    @SerializedName("examination_date")
    private String examinationDate;

    @SerializedName("extra_info")
    private String extraInfo;

    @SerializedName("image")
    private String image;

    @SerializedName("insurance")
    private String insurance;

    @SerializedName("model_name")
    private String modelName;

    @SerializedName("model_year")
    private String modelYear;

    @SerializedName("motor_num")
    private String motorNumber;

    @SerializedName("petrol_type")
    private String petrolType;

    @SerializedName("rest_insurance")
    private String restInsurance;

    @SerializedName("serial_num")
    private String serialNumber;

    @SerializedName("vehicle_type")
    private String vehicleType;


    /**
     * Getter method for {@link #brand}, brand of the vehicle
     *
     * @return "brand" in the API response
     */
    public String getBrand() {
        return brand;
    }

    /**
     * Getter method for {@link #chassisNumber}, chassis number of the vehicle
     *
     * @return "chassis_num" in the API response
     */
    public String getChassisNumber() {
        return chassisNumber;
    }

    /**
     * Getter method for {@link #color}, color of the vehicle
     *
     * @return "color" in the API response
     */
    public String getColor() {
        return color;
    }

    /**
     * Getter method for {@link #cylinders}, cylinders of the vehicle
     *
     * @return "cylinders" in the API response
     */
    public String getCylinders() {
        return cylinders;
    }

    /**
     * Getter method for {@link #engineCapacity}, engine capacity of the vehicle
     *
     * @return "engine_capacity" in the API response
     */
    public String getEngineCapacity() {
        return engineCapacity;
    }

    /**
     * Getter method for {@link #examinationDate}, examination date of the vehicle
     *
     * @return "examination_date" in the API response
     */
    public String getExaminationDate() {
        return examinationDate;
    }

    /**
     * Getter method for {@link #extraInfo}, extra info of the vehicle
     *
     * @return "extra_info" in the API response
     */
    public String getExtraInfo() {
        return extraInfo;
    }

    /**
     * Getter method for {@link #image}, image of the vehicle
     *
     * @return "image" in the API response
     */
    public String getImage() {
        return image;
    }

    /**
     * Getter method for {@link #insurance}, insurance of the vehicle
     *
     * @return "insurance" in the API response
     */
    public String getInsurance() {
        return insurance;
    }

    /**
     * Getter method for {@link #modelName}, model name of the vehicle
     *
     * @return "model_name" in the API response
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Getter method for {@link #modelYear}, model year of the vehicle
     *
     * @return "model_year" in the API response
     */
    public String getModelYear() {
        return modelYear;
    }

    /**
     * Getter method for {@link #motorNumber}, motor number of the vehicle
     *
     * @return "motor_num" in the API response
     */
    public String getMotorNumber() {
        return motorNumber;
    }

    /**
     * Getter method for {@link #petrolType}, petrol type of the vehicle
     *
     * @return "petrol_type" in the API response
     */
    public String getPetrolType() {
        return petrolType;
    }

    /**
     * Getter method for {@link #restInsurance}, rest insurance of the vehicle
     *
     * @return "rest_insurance" in the API response
     */
    public String getRestInsurance() {
        return restInsurance;
    }

    /**
     * Getter method for {@link #serialNumber}, serial number of the vehicle
     *
     * @return "serial_num" in the API response
     */
    public String getSerialNumber() {
        return serialNumber;
    }

    /**
     * Getter method for {@link #vehicleType}, vehicle type of the vehicle
     *
     * @return "vehicle_type" in the API response
     */
    public String getVehicleType() {
        return vehicleType;
    }
}
