package io.digified.digified_library.api.result.internal.vehicle_license;

import com.google.gson.annotations.SerializedName;

public class FrontVehicleLicenseData extends VehicleLicenseData {

    @SerializedName("city")
    private String city;

    @SerializedName("city_detailed")
    private String cityDetailed;

    @SerializedName("expire_date")
    private String expiryDate;

    @SerializedName("vehicle_number")
    private String fullVehicleNumber;

    @SerializedName("governorate")
    private String governorate;

    @SerializedName("image")
    private String image;

    @SerializedName("issue_date")
    private String issueDate;

    @SerializedName("license_type")
    private String licenseType;

    @SerializedName("name")
    private String name;

    @SerializedName("nationality")
    private String nationality;

    @SerializedName("rest_name")
    private String restName;



    /**
     * Getter method for {@link #city}, city of the vehicle
     *
     * @return "city" in the API response
     */
    public String getCity() {
        return city;
    }

    /**
     * Getter method for {@link #cityDetailed}, city detailed of the vehicle
     *
     * @return "city_detailed" in the API response
     */
    public String getCityDetailed() {
        return cityDetailed;
    }

    /**
     * Getter method for {@link #expiryDate}, expiry date of the vehicle
     *
     * @return "expire_date" in the API response
     */
    public String getExpiryDate() {
        return expiryDate;
    }

    /**
     * Getter method for {@link #fullVehicleNumber}, full vehicle number of the vehicle
     *
     * @return "full_vehicle_num" in the API response
     */
    public String getFullVehicleNumber() {
        return fullVehicleNumber;
    }

    /**
     * Getter method for {@link #governorate}, governorate of the vehicle
     *
     * @return "governorate" in the API response
     */
    public String getGovernorate() {
        return governorate;
    }

    /**
     * Getter method for {@link #image}, image of the vehicle
     *
     * @return "image" in the API response
     */
    public String getImage() {
        return image;
    }

    /**
     * Getter method for {@link #issueDate}, issue date of the vehicle
     *
     * @return "issue_date" in the API response
     */
    public String getIssueDate() {
        return issueDate;
    }

    /**
     * Getter method for {@link #licenseType}, license type of the vehicle
     *
     * @return "license_type" in the API response
     */
    public String getLicenseType() {
        return licenseType;
    }

    /**
     * Getter method for {@link #name}, name on the vehicle license
     *
     * @return "name" in the API response
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for {@link #nationality}, nationality of the vehicle
     *
     * @return "nationality" in the API response
     */
    public String getNationality() {
        return nationality;
    }

    /**
     * Getter method for {@link #restName}, rest name of the vehicle
     *
     * @return "rest_name" in the API response
     */
    public String getRestName() {
        return restName;
    }
}
