package io.digified.digified_library.capture.v2.detectors.manual_detector;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;

import androidx.annotation.NonNull;

import com.google.android.gms.tasks.Task;

import io.digified.digified_library.capture.v2.detectors.DetectorInterface;
import io.digified.digified_library.capture.v2.detectors.VisionProcessorBase;
import io.digified.digified_library.capture.v2.detectors.manual_detector.core.ManualDetectedImage;
import io.digified.digified_library.capture.v2.detectors.manual_detector.core.ManualImageDetector;


public class ManualDetectorProcessor extends VisionProcessorBase<ManualDetectedImage> {

    private static final String TAG = "ManualDetectorProcessor";

    private final ManualImageDetector manualImageDetector;
    private final ManualImageSelector manualImageSelector;

    private int previewWidth = 0;
    private int previewHeight = 0;

    public ManualDetectorProcessor(Context context,
                                   int desiredWidth,
                                   int desiredHeight,
                                   int numberOfImages,
                                   int mode,
                                   boolean isFrontCamera,
                                   DetectorInterface detectorInterface) {
        super(context, numberOfImages, detectorInterface);

        manualImageSelector = new ManualImageSelector(desiredWidth, desiredHeight, numberOfImages, detectorInterface);
        manualImageDetector = new ManualImageDetector(desiredWidth, desiredHeight, mode, isFrontCamera);
    }

    @Override
    public void stop() {
        super.stop();
        if (manualImageDetector != null) manualImageDetector.close();
    }

    @Override
    public void setPreviewSizes(int width, int height) {
        previewWidth = width;
        previewHeight = height;
    }

    @Override
    protected Task<ManualDetectedImage> detectInImage(Bitmap image) {
        return manualImageDetector.process(image);
    }

    public void takePhoto() {
        manualImageDetector.capture();
    }

    @Override
    protected void onSuccess(@NonNull ManualDetectedImage results, @NonNull Bitmap originalCameraImage) {
        manualImageSelector.check(results, originalCameraImage);
    }

    @Override
    protected void onFailure(@NonNull Exception e) {
        Log.e(TAG, "ID detection failed!", e);
    }
}
