package io.digified.digified_library.digified;

import androidx.fragment.app.FragmentManager;

import io.digified.digified_library.api.callbacks.FaceMatchCallback;
import io.digified.digified_library.api.callbacks.IdExtractionCallback;
import io.digified.digified_library.api.callbacks.InitializeCallback;
import io.digified.digified_library.capture.CaptureCallback;
import io.digified.digified_library.capture.CaptureResult;

public final class DigifiedConstants {

    /**
     * Contains possible capture types
     */
    public static final class CaptureType {
        /**
         * ID Front Side
         */
        public static final int ID_FRONT = 1;

        /**
         * ID Back Side
         */
        public static final int ID_BACK = 2;

        /**
         * Selfie (face) image
         */
        public static final int SELFIE = 3;

        /**
         * Passport image
         */
        public static final int PASSPORT = 4;

        /**
         * Non Egyptian ID Front
         */
        public static final int Generic_ID_FRONT = 5;

        /**
         * Non Egyptian ID Back
         */
        public static final int Generic_ID_BACK = 6;

        /**
         * Egyptian Vehicle License front
         */
        public static final int VEHICLE_LICENSE_FRONT = 7;

        /**
         * Egyptian Vehicle License back
         */
        public static final int VEHICLE_LICENSE_BACK = 8;
    }

    /**
     * Contains possible actions to be done through the Digified SDK
     */
    public static final class Action {
        /**
         * Used to tell that there is an error
         */
        public static final int UNKNOWN = -1;

        /**
         * Initialize the SDK by calling the following methods:
         * {@link Digified#initialize(String, String, String, String, InitializeCallback)}
         */
        public static final int INITIALIZE = 1;

        /**
         * Capturing the first side of the document (for example the Front Side of the ID)
         * by calling the following methods:
         * {@link Digified#capture(FragmentManager, int, int, CaptureCallback)} or
         * {@link Digified#capture(FragmentManager, int, int, int, int, CaptureCallback)}
         * note that the document could have just one side like the passport
         */
        public static final int CAPTURE_DOCUMENT_FIRST = 2;

        /**
         * Send the captured image of  the first side of the document (CaptureResult) to the API to
         * get the results (for example the Front Side of the ID)
         * by calling the following method: {@link Digified#send(CaptureResult, IdExtractionCallback)}
         * note that the document could have just one side like the passport
         */
        public static final int SEND_DOCUMENT_FIRST = 3;

        /**
         * Capturing the second side of the document (for example theBack Side of the ID)
         * by calling the following methods:
         * {@link Digified#capture(FragmentManager, int, int, CaptureCallback)} or
         * {@link Digified#capture(FragmentManager, int, int, int, int, CaptureCallback)}
         * note that the document could have just one side like the passport
         */
        public static final int CAPTURE_DOCUMENT_SECOND = 4;

        /**
         * Send the captured second side of the document of the document (CaptureResult  to the API
         * to get the results (for example the Back side of the ID)
         * by calling the following method: {@link Digified#send(CaptureResult, IdExtractionCallback)}
         * note that the document could have just one side like the passport
         */
        public static final int SEND_DOCUMENT_SECOND = 5;

        /**
         * Capturing the Selfie Image by calling the following methods:
         * {@link Digified#capture(FragmentManager, int, int, CaptureCallback)} or
         * {@link Digified#capture(FragmentManager, int, int, int, int, CaptureCallback)}
         */
        public static final int CAPTURE_SELFIE = 6;

        /**
         * Send the captured image of Back ID (CaptureResult) to the API to get the results
         * by calling the following method: {@link Digified#send(CaptureResult, FaceMatchCallback)}
         */
        public static final int SEND_SELFIE = 7;

        /**
         * Means that you can call {@link Digified#getFinalStatus()} to get the verification status
         */
        public static final int STATUS_READY = 8;

        /**
         * Arabic transliteration for the name in the ID
         */
        public static final int TRANSLITERATE = 9;

        /**
         * Authorize action helps you to decide if the user is authorized to do some critical actions on your app by
         * checking if the current user made a successful verification before
         */
        public static final int AUTHORIZE = 10;

        /**
         * converts constant integers in {@link Action} to String names for debugging
         *
         * @param action a value from constant integers in {@link Action}
         * @return String name of that action
         */
        public static String actionToString(int action) {
            switch (action) {
                case INITIALIZE:
                    return "INITIALIZE";
                case CAPTURE_DOCUMENT_FIRST:
                    return "CAPTURE_DOCUMENT_FIRST";
                case SEND_DOCUMENT_FIRST:
                    return "SEND_DOCUMENT_FIRST";
                case CAPTURE_DOCUMENT_SECOND:
                    return "CAPTURE_DOCUMENT_SECOND";
                case SEND_DOCUMENT_SECOND:
                    return "SEND_DOCUMENT_SECOND";
                case CAPTURE_SELFIE:
                    return "CAPTURE_SELFIE";
                case SEND_SELFIE:
                    return "SEND_SELFIE";
                case STATUS_READY:
                    return "STATUS_READY";
                case TRANSLITERATE:
                    return "TRANSLITERATE";
                case AUTHORIZE:
                    return "AUTHORIZE";
                default:
                    return "UNKNOWN";

            }
        }
    }

    /**
     * Contains possible status of the verification process
     */
    public static final class Status {
        /**
         * this is the initial value of the verification
         */
        public static final int UNKNOWN = -1;

        /**
         * verification is running at the moment
         */
        public static final int IN_PROGRESS = 1;

        /**
         * user is verified
         */
        public static final int VERIFIED = 2;

        /**
         * user verification needs to be reviewed
         */
        public static final int PENDING = 3;

        /**
         * user verification was rejected
         */
        public static final int REJECTED = 4;

        /**
         * converts constant integers in {@link Status} to String names for debugging
         *
         * @param status a value from constant integers in {@link Status}
         * @return String name of that status
         */
        public static String statusToString(int status) {
            switch (status) {
                case IN_PROGRESS:
                    return "IN_PROGRESS";
                case VERIFIED:
                    return "VERIFIED";
                case PENDING:
                    return "PENDING";
                case REJECTED:
                    return "REJECTED";
                default:
                    return "UNKNOWN";
            }
        }
    }

    /**
     * Contains behaviour on warnings
     */
    public static final class WarningAction {

        /**
         * default: PENDING on warnings
         * Request is pending if there is a warning
         */
        public static final String REPORT = "report";

        /**
         * VERIFIED on warnings
         * Request is accepted / verified if there is a warning
         */
        public static final String IGNORE = "ignore";

        /**
         * FAILED on warnings
         * Request is rejected if there is a warning
         */
        public static final String FAIL = "fail";
    }

    /**
     * Contains the possible authorization results
     * (whether you should allow your user to do a certain action or not)
     */
    public static final class Authorization {
        /**
         * this is the initial value
         */
        public static final int UNKNOWN = -1;

        /**
         * user should be authorized from accessing the action they want to do in your app
         * this means that they have an old verification result that is success full and
         * that the new selfie taken matches the old selfie and it's live as well
         */
        public static final int AUTHORIZE = 1;

//        /**
//         * we're not sure if this user should be authorized, due to old verification is pending
//         */
//        public static final int NOT_SURE = 2;
//
//        /**
//         * there is not enough data as the verified document doesn't have a face image to compare it
//         * to a new selfie
//         */
//        public static final int NO_ENOUGH_DATA = 3;

        /**
         * the process was interrupted by the user (cancelled the new selfie capturing)
         */
        public static final int INTERRUPTED = 2;

        /**
         * used should be forbidden from accessing the action they want to do in your app,
         * either because the old verification is not found, rejected or there is a problem with
         * the new selfie check
         */
        public static final int FORBID = 3;
    }


    /**
     * Containing the document types
     */
    public static final class Document {

        /**
         * Egyptian ID document
         */
        public static final int EGYPTIAN_ID = 1;

        /**
         * Generic ID document
         */
        public static final int GENERIC_ID = 2;

        /**
         * Passport document
         */
        public static final int PASSPORT = 3;

        /**
         * Vehicle License document
         */
        public static final int VEHICLE_LICENSE = 4;

    }
}
