package io.digified.digified_library.digified;

//import android.util.Log;

import java.util.ArrayList;

import io.digified.digified_library.api.ApiConstants.Process;
import io.digified.digified_library.api.result.DigifiedResult;
import io.digified.digified_library.digified.DigifiedConstants.Action;
import io.digified.digified_library.errors.DigifiedError;

class SequenceManager {

    private static final String TAG = "SequenceManager";

    private static final String DOCUMENT_SIDES_MATCH_ERROR = "E6129";

    private boolean verificationStarted;

    private String nextProcess;
    private int lastGrantedAction;

    SequenceManager() {
        nextProcess = Process.INITIALIZE;
        lastGrantedAction = Action.INITIALIZE;
        verificationStarted = false;
    }

    void reset() {
        nextProcess = Process.INITIALIZE;
        lastGrantedAction = Action.INITIALIZE;
        verificationStarted = false;
    }

    boolean isEligibleForAction(int action) {
        if ((action == Action.CAPTURE_DOCUMENT_FIRST && lastGrantedAction == Action.SEND_DOCUMENT_FIRST)
                || (action == Action.CAPTURE_DOCUMENT_SECOND && lastGrantedAction == Action.SEND_DOCUMENT_SECOND)
                || (action == Action.CAPTURE_SELFIE && lastGrantedAction == Action.SEND_SELFIE)
                // checking Eligibility to authorize action, by checking if the user has used init request first or not
                || (action == Action.AUTHORIZE && lastGrantedAction != Action.INITIALIZE && !verificationStarted)
                || (lastGrantedAction == action)) {
            updateStatus(action);
            return true;
        } else {
//            return true;
            return false;
        }
    }

    int selectNextAction(Boolean isSuccess) {
        int currentAction = lastGrantedAction;

        int result;

//        Log.e(TAG, "currentAction = " + Action.actionToString(currentAction)
//                + ", nextProcess = " + nextProcess + ", isSuccess = " + isSuccess);

        if (nextProcess == null || nextProcess.equals(Process.INITIALIZE)) {
            // if next action is null or equals INITIALIZE we are at the beginning of the sequence
            result = Action.INITIALIZE;
            verificationStarted = false;


        } else if (isSuccess == null || !isSuccess) {
            // didn't succeed so repeat the current action (not supposed to be null ever)
            if (currentAction == Action.SEND_DOCUMENT_FIRST) //error in api, take pic again
                result = Action.CAPTURE_DOCUMENT_FIRST;


            else if (currentAction == Action.SEND_DOCUMENT_SECOND) //error in api, take pic again
                result = Action.CAPTURE_DOCUMENT_SECOND;


            else if (currentAction == Action.SEND_SELFIE) //error in api, take pic again
                result = Action.CAPTURE_SELFIE;

            else
                result = currentAction; // an error happened while capturing the front pic so next action is to take it again


        } else if (currentAction == Action.INITIALIZE && nextProcess.equals(Process.EXTRACT)) {
            //initialization is done and next action is to capture the ID front
            result = Action.CAPTURE_DOCUMENT_FIRST;


        } else if (currentAction == Action.CAPTURE_DOCUMENT_FIRST && nextProcess.equals(Process.EXTRACT)) {
            // successfully capture the front pic so next action is send it
            result = Action.SEND_DOCUMENT_FIRST;
            verificationStarted = true;

        } else if (currentAction == Action.SEND_DOCUMENT_FIRST && nextProcess.equals(Process.EXTRACT)) {
            // successfully sent the front id (even with warnings) next action is to take the back pic
            result = Action.CAPTURE_DOCUMENT_SECOND;

        } else if (currentAction == Action.SEND_DOCUMENT_FIRST && nextProcess.equals(Process.MATCH)) {
            // successfully sent the front id (even with warnings) next action is to take selfie pic
            // since we are dealing with a document with a single side
            result = Action.CAPTURE_SELFIE;

        } else if (currentAction == Action.CAPTURE_DOCUMENT_SECOND && nextProcess.equals(Process.EXTRACT)) {
            // successfully capture the back pic so next action is send it
            result = Action.SEND_DOCUMENT_SECOND;


        } else if (currentAction == Action.SEND_DOCUMENT_SECOND && nextProcess.equals(Process.EXTRACT)) {
            //this means that we sent the back id and it had an error that's why next action is EXTRACT
            //so we will ask for capturing the back again
            result = Action.CAPTURE_DOCUMENT_SECOND;


        } else if (currentAction == Action.SEND_DOCUMENT_SECOND && nextProcess.equals(Process.MATCH)) {
            // successfully the back id (even with warnings) next action is to take a selfie
            result = Action.CAPTURE_SELFIE;


        } else if (currentAction == Action.CAPTURE_SELFIE && nextProcess.equals(Process.MATCH)) {
            // successfully captured the selfie so we should send it
            result = Action.SEND_SELFIE;


        } else if (currentAction == Action.SEND_SELFIE && nextProcess.equals(Process.MATCH)) {
            //this means that we sent the selfie and it had an error that's why next action is MATCH
            //so we will ask for capturing the selfie again
            result = Action.CAPTURE_SELFIE;


        } else if (currentAction == Action.SEND_SELFIE && nextProcess.equals(Process.TRANSLITERATE)) {
            //selfie sent and now we will ask the user to do the transliteration
            result = Action.TRANSLITERATE;


        } else if (currentAction == Action.INITIALIZE && nextProcess.equals((Process.MATCH))) {
            //license has only match (no extraction)
            result = Action.CAPTURE_SELFIE;

        } else if ((currentAction == Action.SEND_DOCUMENT_FIRST ||
                currentAction == Action.SEND_DOCUMENT_SECOND ||
                currentAction == Action.SEND_SELFIE ||
                currentAction == Action.TRANSLITERATE) &&
                nextProcess.equals(Process.DONE)) {
            //selfie sent and everything is okay
            result = Action.STATUS_READY;
            verificationStarted = false;

        } else {
            result = Action.INITIALIZE;
            verificationStarted = false;
        }


//        Log.e(TAG, "result : " + Action.actionToString(result));

        lastGrantedAction = result;

        return result;
    }

    private void updateStatus(int action) {
        lastGrantedAction = action;
    }

    void updateStatus(DigifiedResult digifiedResult) {
        if (digifiedResult != null) {
            String result = digifiedResult.getNextProcess();
            Boolean shouldTerminate = digifiedResult.getShouldTerminate();
            String error = digifiedResult.getError();
            ArrayList<String> errorCodes = digifiedResult.getErrorCode();

//            Log.e(TAG, "updateStatus: result = " + result);
//            Log.e(TAG, "updateStatus: shouldTerminate = " + shouldTerminate);
            if (shouldTerminate != null &&
                    !shouldTerminate &&
                    errorCodes != null &&
                    errorCodes.contains(DOCUMENT_SIDES_MATCH_ERROR)) {
                nextProcess = Process.EXTRACT;
                lastGrantedAction = Action.CAPTURE_DOCUMENT_FIRST;
                return;
            } else if (shouldTerminate != null && !shouldTerminate && result != null) {
                nextProcess = result;
                return;
            } else if (shouldTerminate != null && shouldTerminate && error == null) { //&& result.equals(Process.DONE)) {
                nextProcess = Process.DONE;
                return;
            }
        }

        nextProcess = Process.INITIALIZE;
    }

    void updateStatus(DigifiedError digifiedError) {
        if (digifiedError.isTerminationError()) {
            nextProcess = Process.INITIALIZE;
        }
    }


}
