package io.digified.digified_library.errors;


import io.digified.digified_library.digified.Digified;
import io.digified.digified_library.digified.DigifiedConstants;

public class DigifiedError {

    private final String errorCode;
    private final boolean shouldTerminate;

    /**
     * Constructor for Digified Error
     *
     * @param errorCode       error code from {@link ErrorConstants}
     * @param shouldTerminate whether you should terminate the session or not,
     *                        if session is terminated {@link Digified#getNextAction()}
     *                        will be reset to {@link DigifiedConstants.Action#INITIALIZE}
     */
    public DigifiedError(String errorCode, boolean shouldTerminate) {
        this.errorCode = errorCode;
        this.shouldTerminate = shouldTerminate;
    }

    /**
     * Constructor for Digified Error, in this implementation of the constructor,
     * the error is not a termination error {@link #shouldTerminate} = false
     *
     * @param errorCode error code from {@link ErrorConstants}
     */
    public DigifiedError(String errorCode) {
        this.errorCode = errorCode;
        this.shouldTerminate = false;
    }

    /**
     * Getter method for {@link #errorCode}
     *
     * @return the error code of this DigifiedError
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Getter method for {@link #shouldTerminate}
     * if session is terminated {@link Digified#getNextAction()}
     * will be reset to {@link DigifiedConstants.Action#INITIALIZE}
     *
     * @return whether or not should we terminate the session
     */
    public boolean isTerminationError() {
        return shouldTerminate;
    }
}
