package io.digified.digified_library.errors;


import androidx.fragment.app.FragmentManager;

import io.digified.digified_library.api.callbacks.FaceMatchCallback;
import io.digified.digified_library.api.callbacks.IdExtractionCallback;
import io.digified.digified_library.capture.CaptureCallback;
import io.digified.digified_library.capture.CaptureResult;
import io.digified.digified_library.digified.Digified;

public class ErrorConstants {

    /**
     * Send Error Codes that may occur while using
     * {@link Digified#send(CaptureResult, IdExtractionCallback)} or
     * {@link Digified#send(CaptureResult, FaceMatchCallback)}
     */
    public static final class SendError {
        /**
         * API KEY is null or empty
         */
        public static final String API_KEY_ERROR = "ES101";

        /**
         *  error with the API response, check the logs for more details
         */
        public static final String RESPONSE_ERROR = "ES102";

        /**
         * not connected to the internet to make the api calls
         */
        public static final String NO_NETWORK_CONNECTION = "ES103";

        /**
         * image is null, make sure you have captured an image first
         */
        public static final String IMAGE_FILE_ERROR = "ES104";

        /**
         * you used invalid capture type, make sure you are using the capture type
         * with it's corresponding callback interface
         */
        public static final String INVALID_CAPTURE_TYPE = "ES105";

        /**
         * you didn't follow the sequence of actions provided to use the Digified SDK
         * it's better that you use {@link Digified#getNextAction()} to follow the sequence
         */
        public static final String SEQUENCE_ERROR = "ES106";

        /**
         * capture result is null
         */
        public static final String CAPTURE_RESULT_NULL = "ES107";
    }

    /**
     * Capture error codes that may occur while using
     * {@link Digified#capture(FragmentManager, int, int, CaptureCallback)} or
     * {@link Digified#capture(FragmentManager, int, int, int, int, CaptureCallback)}
     */
    public static final class CaptureError {

        /**
         * camera error occurred, check the logs for more details
         */
        public static final String CAMERA_ERROR = "ES201";

        /**
         * camera permission isn't granted
         */
        public static final String CAMERA_PERMISSION_ERROR = "ES202";

        /**
         * error occurred while creating the capture result, check the logs for more info
         */
        public static final String CAPTURE_RESULT_ERROR = "ES203";

        /**
         * error happened in the detection process, check the logs for more info
         */
        public static final String DETECTION_ERROR = "ES204";

        /**
         * you didn't follow the sequence of actions provided to use the Digified SDK
         * it's better that you use {@link Digified#getNextAction()} to follow the sequence
         */
        public static final String SEQUENCE_ERROR = "ES205";
    }
}
