/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.Bean;
import io.dinject.Factory;
import io.dinject.Primary;
import io.dinject.Secondary;
import io.dinject.generator.Append;
import io.dinject.generator.Constants;
import io.dinject.generator.FieldReader;
import io.dinject.generator.GenericType;
import io.dinject.generator.MetaData;
import io.dinject.generator.MethodReader;
import io.dinject.generator.ProcessingContext;
import io.dinject.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

class BeanReader {
    private static Set<String> EXCLUDED_ANNOTATIONS = new HashSet<String>();
    private final TypeElement beanType;
    private final ProcessingContext context;
    private final String shortName;
    private String name;
    private MethodReader injectConstructor;
    private final List<MethodReader> otherConstructors = new ArrayList<MethodReader>();
    private List<MethodReader> factoryMethods = new ArrayList<MethodReader>();
    private Element postConstructMethod;
    private Element preDestroyMethod;
    private final List<FieldReader> injectFields = new ArrayList<FieldReader>();
    private final List<String> interfaceTypes = new ArrayList<String>();
    private String addForType;
    private Set<String> importTypes = new TreeSet<String>();
    private MethodReader constructor;
    private String registrationTypes;
    private boolean writtenToFile;
    private boolean beanLifeCycle;
    private boolean primary;
    private boolean secondary;

    BeanReader(TypeElement beanType, ProcessingContext context) {
        this.beanType = beanType;
        this.shortName = beanType.getSimpleName().toString();
        this.context = context;
        this.init();
    }

    private void init() {
        Object ifaceType;
        StringBuilder sb = new StringBuilder();
        for (TypeMirror typeMirror : this.beanType.getInterfaces()) {
            String type = Util.unwrapProvider(typeMirror.toString());
            if (Constants.isBeanLifecycle(type)) {
                this.beanLifeCycle = true;
                continue;
            }
            this.interfaceTypes.add(type);
            if (GenericType.isGeneric(type)) continue;
            this.importTypes.add(type);
            sb.append(", ").append(Util.shortName(type)).append(".class");
        }
        if (this.interfaceTypes.size() == 1 && !GenericType.isGeneric((String)(ifaceType = this.interfaceTypes.get(0)))) {
            this.addForType = Util.addForInterface((String)ifaceType);
        }
        for (AnnotationMirror annotationMirror : this.beanType.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Qualifier qualifier = annotationType.asElement().getAnnotation(Qualifier.class);
            String annType = annotationType.toString();
            if (qualifier != null) {
                this.name = Util.shortName(annType);
                continue;
            }
            if (!this.includeAnnotation(annType)) continue;
            this.importTypes.add(annType);
            sb.append(", ").append(Util.shortName(annType)).append(".class");
        }
        Named named = this.beanType.getAnnotation(Named.class);
        if (named != null) {
            this.name = named.value();
        }
        this.primary = this.beanType.getAnnotation(Primary.class) != null;
        this.secondary = !this.primary && this.beanType.getAnnotation(Secondary.class) != null;
        this.registrationTypes = sb.toString();
    }

    TypeElement getBeanType() {
        return this.beanType;
    }

    String getName() {
        return this.name;
    }

    Element getPostConstructMethod() {
        return this.postConstructMethod;
    }

    Element getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    List<FieldReader> getInjectFields() {
        return this.injectFields;
    }

    void read(boolean factory) {
        for (Element element : this.beanType.getEnclosedElements()) {
            ElementKind kind = element.getKind();
            switch (kind) {
                case CONSTRUCTOR: {
                    this.readConstructor(element);
                    break;
                }
                case FIELD: {
                    this.readField(element);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, factory);
                }
            }
        }
        this.constructor = this.findConstructor();
        if (this.constructor != null) {
            this.constructor.addImports(this.importTypes);
        }
        for (MethodReader methodReader : this.factoryMethods) {
            methodReader.addImports(this.importTypes);
        }
    }

    private MethodReader findConstructor() {
        if (this.injectConstructor != null) {
            return this.injectConstructor;
        }
        if (this.otherConstructors.size() == 1) {
            return this.otherConstructors.get(0);
        }
        return null;
    }

    List<String> getDependsOn() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.constructor != null) {
            for (MethodReader.MethodParam param : this.constructor.getParams()) {
                list.add(param.getDependsOn());
            }
        }
        return list;
    }

    List<MethodReader> getFactoryMethods() {
        return this.factoryMethods;
    }

    List<String> getInterfaces() {
        return this.interfaceTypes;
    }

    String getInterfacesAndAnnotations() {
        return this.registrationTypes;
    }

    private boolean includeAnnotation(String annotationType) {
        return !EXCLUDED_ANNOTATIONS.contains(annotationType);
    }

    private void readConstructor(Element element) {
        ExecutableElement ex = (ExecutableElement)element;
        MethodReader methodReader = new MethodReader(this.context, ex, this.beanType, null);
        methodReader.read();
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectConstructor = methodReader;
        } else {
            this.otherConstructors.add(methodReader);
        }
    }

    private void readField(Element element) {
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectFields.add(new FieldReader(element));
        }
    }

    private void readMethod(Element element, boolean factory) {
        Bean bean;
        ExecutableElement methodElement = (ExecutableElement)element;
        if (factory && (bean = element.getAnnotation(Bean.class)) != null) {
            this.addFactoryMethod(methodElement, bean);
        }
        if (this.context.isPostConstructAvailable()) {
            PreDestroy pdMarker;
            PostConstruct pcMarker = element.getAnnotation(PostConstruct.class);
            if (pcMarker != null) {
                this.postConstructMethod = element;
            }
            if ((pdMarker = element.getAnnotation(PreDestroy.class)) != null) {
                this.preDestroyMethod = element;
            }
        }
    }

    private void addFactoryMethod(ExecutableElement methodElement, Bean bean) {
        MethodReader methodReader = new MethodReader(this.context, methodElement, this.beanType, bean);
        methodReader.read();
        this.factoryMethods.add(methodReader);
    }

    String getSimpleName() {
        return this.beanType.getSimpleName().toString();
    }

    boolean isLifecycleRequired() {
        return this.beanLifeCycle || this.isLifecycleWrapperRequired();
    }

    boolean isLifecycleWrapperRequired() {
        return this.postConstructMethod != null || this.preDestroyMethod != null;
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.beanType.getQualifiedName().toString());
        metaData.update(this);
        return metaData;
    }

    boolean isFieldInjectionRequired() {
        return !this.injectFields.isEmpty();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.addForType != null) {
            writer.append(this.addForType).append(".class, ");
        }
        writer.append(this.shortName).append(".class)) {").eol();
    }

    void buildRegister(Append writer) {
        writer.append("      ");
        if (this.isFieldInjectionRequired() || this.isLifecycleRequired()) {
            writer.append("%s $bean = ", this.shortName);
        }
        String flags = this.primary ? "Primary" : (this.secondary ? "Secondary" : "");
        writer.append("builder.register%s(bean, ", flags);
        if (this.name == null) {
            writer.append("null");
        } else {
            writer.append("\"%s\"", this.name);
        }
        writer.append(this.getInterfacesAndAnnotations()).append(");").eol();
    }

    void buildAddLifecycle(Append writer) {
        writer.append("      builder.addLifecycle(");
        if (this.beanLifeCycle) {
            writer.append("$bean");
        } else {
            writer.append("new %s$di($bean)", this.shortName);
        }
        writer.append(");").eol();
    }

    private Set<String> importTypes() {
        String generated;
        if (this.isLifecycleWrapperRequired()) {
            this.importTypes.add("io.dinject.core.BeanLifecycle");
        }
        if ((generated = this.context.getGeneratedAnnotation()) != null) {
            this.importTypes.add(generated);
        }
        this.importTypes.add("io.dinject.core.Builder");
        this.importTypes.add(this.beanType.getQualifiedName().toString());
        return this.importTypes;
    }

    void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    MethodReader getConstructor() {
        return this.constructor;
    }

    boolean isWrittenToFile() {
        return this.writtenToFile;
    }

    void setWrittenToFile() {
        this.writtenToFile = true;
    }

    static {
        EXCLUDED_ANNOTATIONS.add("javax.annotation.Generated");
        EXCLUDED_ANNOTATIONS.add(Singleton.class.getName());
        EXCLUDED_ANNOTATIONS.add(Named.class.getName());
        EXCLUDED_ANNOTATIONS.add(Factory.class.getName());
        EXCLUDED_ANNOTATIONS.add(Primary.class.getName());
        EXCLUDED_ANNOTATIONS.add(Secondary.class.getName());
        EXCLUDED_ANNOTATIONS.add("kotlin.Metadata");
        EXCLUDED_ANNOTATIONS.add("io.dinject.controller.Path");
        EXCLUDED_ANNOTATIONS.add("lombok.extern.slf4j.Slf4j");
        EXCLUDED_ANNOTATIONS.add("lombok.Getter");
        EXCLUDED_ANNOTATIONS.add("lombok.Setter");
        EXCLUDED_ANNOTATIONS.add("lombok.EqualsAndHashCode");
        EXCLUDED_ANNOTATIONS.add("lombok.ToString");
    }
}

