/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.generator.Append;
import io.dinject.generator.GenericTypeParser;
import io.dinject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class GenericType {
    private String mainType;
    private List<GenericType> params = new ArrayList<GenericType>();

    GenericType() {
    }

    static boolean isGeneric(String raw) {
        return raw.contains("<");
    }

    static GenericType parse(String raw) {
        return new GenericTypeParser(raw).parse();
    }

    static GenericType maybe(String paramType) {
        return GenericType.isGeneric(paramType) ? GenericType.parse(paramType) : null;
    }

    void addImports(Set<String> importTypes) {
        String type = this.trimExtends();
        if (this.includeInImports(type)) {
            importTypes.add(type);
        }
        for (GenericType param : this.params) {
            param.addImports(importTypes);
        }
    }

    private boolean includeInImports(String type) {
        return !type.startsWith("java.lang.") && type.contains(".");
    }

    void writeShort(Append writer) {
        String main = Util.shortName(this.trimExtends());
        writer.append(main);
        int paramCount = this.params.size();
        if (paramCount > 0) {
            writer.append("<");
            for (int i = 0; i < paramCount; ++i) {
                if (i > 0) {
                    writer.append(",");
                }
                this.params.get(i).writeShort(writer);
            }
            writer.append(">");
        }
    }

    private String trimExtends() {
        if (this.mainType.startsWith("? extends ")) {
            return this.mainType.substring(10);
        }
        return this.mainType;
    }

    String getMainType() {
        return this.mainType;
    }

    List<GenericType> getParams() {
        return this.params;
    }

    void setMainType(String mainType) {
        this.mainType = mainType;
    }

    void addParam(GenericType param) {
        this.params.add(param);
    }
}

