/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.generator.GenericType;
import java.util.Stack;

class GenericTypeParser {
    private final String raw;
    private StringBuilder buf = new StringBuilder();
    private Stack<GenericType> stack = new Stack();

    GenericTypeParser(String raw) {
        this.raw = raw;
        this.stack.push(new GenericType());
    }

    GenericType parse() {
        int len = this.raw.length();
        for (int i = 0; i < len; ++i) {
            char ch = this.raw.charAt(i);
            this.processChar(ch);
        }
        return this.stack.peek();
    }

    private void processChar(char ch) {
        switch (ch) {
            case '<': {
                this.startParam();
                break;
            }
            case '>': {
                this.endParam();
                break;
            }
            case ',': {
                this.nextParam();
                break;
            }
            default: {
                this.buf.append(ch);
            }
        }
    }

    private void nextParam() {
        this.endParam();
        GenericType param = new GenericType();
        this.stack.peek().addParam(param);
        this.stack.push(param);
    }

    private void endParam() {
        String content = this.buf.toString();
        if (!content.isEmpty()) {
            this.stack.peek().setMainType(content);
            this.buf = new StringBuilder();
        }
        this.stack.pop();
    }

    private void startParam() {
        this.stack.peek().setMainType(this.buf.toString());
        this.buf = new StringBuilder();
        GenericType param = new GenericType();
        this.stack.peek().addParam(param);
        this.stack.push(param);
    }
}

