/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.core.DependencyMeta;
import io.dinject.generator.BeanReader;
import io.dinject.generator.GenericType;
import io.dinject.generator.MetaDataOrdering;
import io.dinject.generator.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class MetaData {
    private static final String NEWLINE = "\n";
    private final String type;
    private String method;
    private boolean wired;
    private List<String> provides;
    private List<String> dependsOn;

    MetaData(DependencyMeta meta) {
        this.type = meta.type();
        this.method = meta.method();
        this.provides = this.asList(meta.provides());
        this.dependsOn = this.asList(meta.dependsOn());
    }

    MetaData(String type) {
        this.type = type;
        this.provides = new ArrayList<String>();
        this.dependsOn = new ArrayList<String>();
    }

    boolean noDepends() {
        return this.dependsOn == null || this.dependsOn.isEmpty();
    }

    boolean isWired() {
        return this.wired;
    }

    void setWired() {
        this.wired = true;
    }

    private List<String> asList(String[] content) {
        if (content == null || content.length == 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList(content);
    }

    void update(BeanReader beanReader) {
        this.provides = beanReader.getInterfaces();
        this.dependsOn = beanReader.getDependsOn();
    }

    String getType() {
        return this.type;
    }

    List<String> getProvides() {
        return this.provides;
    }

    List<String> getDependsOn() {
        return this.dependsOn;
    }

    String getTopPackage() {
        if (this.method == null || this.method.isEmpty()) {
            return Util.packageOf(this.type);
        }
        return null;
    }

    void addImportTypes(Set<String> importTypes) {
        if (this.hasMethod()) {
            importTypes.add(Util.classOfMethod(this.method));
        } else {
            importTypes.add(this.type + "$di");
        }
        if (this.provides != null) {
            for (String provide : this.provides) {
                if (!GenericType.isGeneric(provide)) continue;
                importTypes.add(this.type);
            }
        }
    }

    String buildMethod(MetaDataOrdering ordering) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("  @DependencyMeta(type=\"").append(this.type).append("\"");
        if (this.hasMethod()) {
            sb.append(", method=\"").append(this.method).append("\"");
        }
        if (!this.provides.isEmpty()) {
            this.appendProvides(sb, "provides", this.provides);
        }
        if (!this.dependsOn.isEmpty()) {
            this.appendProvides(sb, "dependsOn", this.dependsOn);
        }
        sb.append(")").append(NEWLINE);
        String shortName = Util.shortName(this.type);
        sb.append("  protected void build_").append(shortName).append("() {").append(NEWLINE);
        if (this.hasMethod()) {
            sb.append("    ").append(Util.shortMethod(this.method)).append("(builder");
        } else {
            sb.append("    ").append(shortName).append("$di.build(builder");
        }
        for (String depend : this.dependsOn) {
            if (!GenericType.isGeneric(depend)) continue;
            MetaData providerMeta = this.findProviderOf(depend, ordering);
            String prov = providerMeta == null ? "UnknownProvider" : Util.shortName(providerMeta.type);
            sb.append(", () -> {").append(NEWLINE);
            sb.append("      return builder.get(").append(prov).append(".class);").append(NEWLINE);
            sb.append("    }");
        }
        sb.append(");").append(NEWLINE);
        sb.append("  }").append(NEWLINE);
        return sb.toString();
    }

    private MetaData findProviderOf(String depend, MetaDataOrdering ordering) {
        return ordering.findProviderOf(depend);
    }

    private boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    private void appendProvides(StringBuilder sb, String attribute, List<String> types) {
        sb.append(",").append(attribute).append("={");
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(types.get(i));
            sb.append("\"");
        }
        sb.append("}");
    }

    void setProvides(List<String> provides) {
        this.provides = provides;
    }

    void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    void setMethod(String method) {
        this.method = method;
    }

    String getShortType() {
        return Util.shortName(this.type);
    }
}

