/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.Bean;
import io.dinject.generator.Append;
import io.dinject.generator.Constants;
import io.dinject.generator.GenericType;
import io.dinject.generator.MetaData;
import io.dinject.generator.ProcessingContext;
import io.dinject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class MethodReader {
    private final ProcessingContext processingContext;
    private final ExecutableElement element;
    private final String factoryType;
    private final TypeMirror returnType;
    private final String returnTypeRaw;
    private final String shortName;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final List<String> interfaceTypes = new ArrayList<String>();
    private final String factoryShortName;
    private final boolean isFactory;
    private final String initMethod;
    private final String destroyMethod;
    private String addForType;
    private boolean beanLifeCycle;

    MethodReader(ProcessingContext processingContext, ExecutableElement element, TypeElement beanType, Bean bean) {
        this.isFactory = bean != null;
        this.processingContext = processingContext;
        this.element = element;
        this.returnType = element.getReturnType();
        this.returnTypeRaw = this.returnType.toString();
        this.shortName = Util.shortName(this.returnTypeRaw);
        this.factoryType = beanType.getQualifiedName().toString();
        this.factoryShortName = Util.shortName(this.factoryType);
        this.isVoid = this.returnTypeRaw.equals("void");
        this.initMethod = bean == null ? null : bean.initMethod();
        this.destroyMethod = bean == null ? null : bean.destroyMethod();
        this.initInterfaces();
    }

    private void initInterfaces() {
        Element element = this.processingContext.asElement(this.returnType);
        if (element instanceof TypeElement) {
            TypeElement te = (TypeElement)element;
            if (te.getKind() == ElementKind.INTERFACE) {
                this.interfaceTypes.add(te.getQualifiedName().toString());
            }
            for (TypeMirror typeMirror : te.getInterfaces()) {
                if (Constants.isBeanLifecycle(typeMirror.toString())) {
                    this.beanLifeCycle = true;
                    continue;
                }
                this.interfaceTypes.add(typeMirror.toString());
            }
            if (this.interfaceTypes.size() == 1) {
                this.addForType = this.interfaceTypes.get(0);
            }
        }
    }

    void read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
    }

    List<MethodParam> getParams() {
        return this.params;
    }

    String getName() {
        return this.element.getSimpleName().toString();
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.returnTypeRaw);
        metaData.setMethod(this.fullBuildMethod());
        ArrayList<String> dependsOn = new ArrayList<String>(this.params.size() + 1);
        dependsOn.add(this.factoryType);
        for (MethodParam param : this.params) {
            dependsOn.add(param.paramType);
        }
        metaData.setDependsOn(dependsOn);
        metaData.setProvides(new ArrayList<String>());
        return metaData;
    }

    private String fullBuildMethod() {
        return this.factoryType + "$di.build_" + this.element.getSimpleName().toString();
    }

    String builderGetFactory() {
        return String.format("      %s factory = builder.get(%s.class);", this.factoryShortName, this.factoryShortName);
    }

    String builderBuildBean() {
        String methodName = this.element.getSimpleName().toString();
        StringBuilder sb = new StringBuilder();
        if (this.isVoid) {
            sb.append(String.format("      factory.%s(", methodName));
        } else {
            sb.append(String.format("      %s bean = factory.%s(", Util.shortName(this.returnTypeRaw), methodName));
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.params.get(i).builderGetDependency());
        }
        sb.append(");");
        return sb.toString();
    }

    void builderBuildAddBean(Append writer) {
        if (!this.isVoid) {
            writer.append("      ");
            if (this.beanLifeCycle || this.hasLifecycleMethods()) {
                writer.append("      %s $bean = ", this.shortName);
            }
            writer.append("builder.register(bean, null", this.shortName);
            for (String anInterface : this.interfaceTypes) {
                writer.append(", ").append(Util.shortName(anInterface)).append(".class");
            }
            writer.append(");").eol();
            if (this.beanLifeCycle) {
                writer.append("      builder.addLifecycle($bean);").eol();
            } else if (this.hasLifecycleMethods()) {
                writer.append("      builder.addLifecycle(new %s$lifecycle($bean));", this.shortName).eol();
            }
        }
    }

    private boolean hasLifecycleMethods() {
        return this.notEmpty(this.initMethod) || this.notEmpty(this.destroyMethod);
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    void addImports(Set<String> importTypes) {
        for (MethodParam param : this.params) {
            param.addImports(importTypes);
        }
        if (this.isFactory) {
            importTypes.add(this.returnTypeRaw);
        }
        if (this.beanLifeCycle || this.hasLifecycleMethods()) {
            importTypes.add("io.dinject.core.BeanLifecycle");
        }
        importTypes.addAll(this.interfaceTypes);
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.addForType != null) {
            writer.append(this.addForType).append(".class, ");
        }
        if (this.isVoid) {
            writer.append("Void.class)) {").eol();
        } else {
            writer.append(this.shortName).append(".class)) {").eol();
        }
    }

    void buildLifecycleClass(Append writer) {
        if (!this.hasLifecycleMethods()) {
            return;
        }
        writer.append("  static class %s$lifecycle implements BeanLifecycle {", this.shortName).eol().eol();
        writer.append("    final %s bean;", this.shortName).eol().eol();
        writer.append("    %s$lifecycle(%s bean) {", this.shortName, this.shortName).eol();
        writer.append("      this.bean = bean;").eol();
        writer.append("    }").eol().eol();
        writer.append("    @Override").eol();
        writer.append("    public void postConstruct() {").eol();
        if (this.notEmpty(this.initMethod)) {
            writer.append("      bean.%s();", this.initMethod).eol();
        } else {
            writer.append("      // do nothing ").eol();
        }
        writer.append("    }").eol().eol();
        writer.append("    @Override").eol();
        writer.append("    public void preDestroy() {").eol();
        if (this.notEmpty(this.destroyMethod)) {
            writer.append("      bean.%s();", this.destroyMethod).eol();
        } else {
            writer.append("      // do nothing ").eol();
        }
        writer.append("    }").eol();
        writer.append("  }").eol().eol();
    }

    static class MethodParam {
        private final String rawType;
        private final String named;
        private final boolean listType;
        private final boolean optionalType;
        private final String paramType;
        private final GenericType genericType;
        private int providerIndex;

        MethodParam(VariableElement param) {
            TypeMirror type = param.asType();
            this.rawType = type.toString();
            this.named = Util.getNamed(param);
            this.listType = Util.isList(this.rawType);
            boolean bl = this.optionalType = !this.listType && Util.isOptional(this.rawType);
            this.paramType = this.optionalType ? Util.extractOptionalType(this.rawType) : (this.listType ? Util.extractList(this.rawType) : this.rawType);
            this.genericType = GenericType.maybe(this.paramType);
        }

        String builderGetDependency() {
            StringBuilder sb = new StringBuilder();
            if (this.genericType != null) {
                sb.append("prov").append(this.providerIndex).append(".get(");
            } else if (this.listType) {
                sb.append("builder.getList(");
            } else if (this.optionalType) {
                sb.append("builder.getOptional(");
            } else {
                sb.append("builder.get(");
            }
            if (this.genericType == null) {
                sb.append(Util.shortName(this.paramType)).append(".class");
            }
            if (this.named != null) {
                sb.append(",\"").append(this.named).append("\"");
            }
            sb.append(")");
            return sb.toString();
        }

        boolean isGenericType() {
            return this.genericType != null;
        }

        String getDependsOn() {
            return this.paramType;
        }

        void addImports(Set<String> importTypes) {
            if (this.genericType != null) {
                importTypes.add("javax.inject.Provider");
                this.genericType.addImports(importTypes);
            } else {
                importTypes.add(this.paramType);
            }
        }

        void addProviderParam(Append writer, int providerIndex) {
            this.providerIndex = providerIndex;
            writer.append(", ");
            writer.append("Provider<");
            this.genericType.writeShort(writer);
            writer.append("> prov%s", providerIndex);
        }
    }
}

