/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.generator.Append;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class ProcessingContext {
    private final ProcessingEnvironment processingEnv;
    private final Messager messager;
    private final Filer filer;
    private final Elements elementUtils;
    private final Types typeUtils;
    private final String generatedAnnotation;
    private String contextName;
    private String[] contextProvides;
    private String[] contextDependsOn;
    private String contextPackage;
    private String metaInfServicesLine;

    ProcessingContext(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        boolean jdk8 = processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_8) <= 0;
        this.generatedAnnotation = this.generatedAnnotation(jdk8);
    }

    private String generatedAnnotation(boolean jdk8) {
        if (jdk8) {
            return this.isTypeAvailable("javax.annotation.Generated") ? "javax.annotation.Generated" : null;
        }
        return this.isTypeAvailable("javax.annotation.processing.Generated") ? "javax.annotation.processing.Generated" : null;
    }

    private boolean isTypeAvailable(String canonicalName) {
        return null != this.elementUtils.getTypeElement(canonicalName);
    }

    boolean isPostConstructAvailable() {
        return this.isTypeAvailable("javax.annotation.PostConstruct");
    }

    boolean isGeneratedAvailable() {
        return this.generatedAnnotation != null;
    }

    String getGeneratedAnnotation() {
        return this.generatedAnnotation;
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logError(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    void logWarn(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    void logDebug(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    String loadMetaInfServices() {
        if (this.metaInfServicesLine == null) {
            this.metaInfServicesLine = this.loadMetaInf();
        }
        return this.metaInfServicesLine;
    }

    private String loadMetaInf() {
        try {
            Reader reader;
            LineNumberReader lineReader;
            String line;
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.dinject.core.BeanContextFactory");
            if (fileObject != null && (line = (lineReader = new LineNumberReader(reader = fileObject.openReader(true))).readLine()) != null) {
                return line.trim();
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            this.logDebug("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    JavaFileObject createWriter(String cls) throws IOException {
        return this.filer.createSourceFile(cls, new Element[0]);
    }

    FileObject createMetaInfWriter() throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.dinject.core.BeanContextFactory", new Element[0]);
    }

    void setContextDetails(String name, String[] provides, String[] dependsOn, Element contextElement) {
        this.contextName = name;
        this.contextProvides = provides;
        this.contextDependsOn = dependsOn;
        PackageElement pkg = this.elementUtils.getPackageOf(contextElement);
        this.logWarn("using package from element " + pkg, new Object[0]);
        this.contextPackage = pkg == null ? null : pkg.getQualifiedName().toString();
    }

    void deriveContextName(String factoryPackage) {
        if (this.contextName == null) {
            this.contextName = factoryPackage;
        }
    }

    String getContextPackage() {
        return this.contextPackage;
    }

    Element asElement(TypeMirror returnType) {
        return this.typeUtils.asElement(returnType);
    }

    void buildNewBuilder(Append writer) {
        writer.append("    this.builder = BuilderFactory.newBuilder(\"%s\"", this.contextName);
        writer.append(", ");
        this.buildStringArray(writer, this.contextProvides, true);
        writer.append(", ");
        this.buildStringArray(writer, this.contextDependsOn, true);
        writer.append(");").eol();
    }

    void buildAtContextModule(Append writer) {
        if (this.isGeneratedAvailable()) {
            writer.append("@Generated(\"io.dinject.generator\")").eol();
        }
        writer.append("@ContextModule(name=\"%s\"", this.contextName);
        if (!this.isEmpty(this.contextProvides)) {
            writer.append(", provides=");
            this.buildStringArray(writer, this.contextProvides, false);
        }
        if (!this.isEmpty(this.contextDependsOn)) {
            writer.append(", dependsOn=");
            this.buildStringArray(writer, this.contextDependsOn, false);
        }
        writer.append(")").eol();
    }

    private boolean isEmpty(String[] strings) {
        return strings == null || strings.length == 0;
    }

    private void buildStringArray(Append writer, String[] values, boolean asArray) {
        if (this.isEmpty(values)) {
            writer.append("null");
        } else {
            if (asArray) {
                writer.append("new String[]");
            }
            writer.append("{");
            int c = 0;
            for (String value : values) {
                if (c++ > 0) {
                    writer.append(",");
                }
                writer.append("\"").append(value).append("\"");
            }
            writer.append("}");
        }
    }
}

