/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.generator.Append;
import io.dinject.generator.BeanReader;
import io.dinject.generator.FieldReader;
import io.dinject.generator.MethodReader;
import io.dinject.generator.ProcessingContext;
import io.dinject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

class SimpleBeanWriter {
    private final BeanReader beanReader;
    private final ProcessingContext ctx;
    private Append writer;
    private String originName;
    private String shortName;
    private String packageName;

    SimpleBeanWriter(BeanReader beanReader, ProcessingContext ctx) {
        this.beanReader = beanReader;
        this.ctx = ctx;
        TypeElement origin = beanReader.getBeanType();
        this.originName = origin.getQualifiedName().toString();
        this.shortName = origin.getSimpleName().toString();
        this.packageName = Util.packageOf(this.originName);
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.ctx.createWriter(this.originName + "$di");
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeStaticFactoryMethod();
        this.writeStaticFactoryBeanMethods();
        this.writeLifecycleWrapper();
        this.writeStaticFactoryBeanLifecycle();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeStaticFactoryBeanMethods() {
        for (MethodReader factoryMethod : this.beanReader.getFactoryMethods()) {
            this.writeFactoryBeanMethod(factoryMethod);
        }
    }

    private void writeStaticFactoryBeanLifecycle() {
        for (MethodReader factoryMethod : this.beanReader.getFactoryMethods()) {
            factoryMethod.buildLifecycleClass(this.writer);
        }
    }

    private void writeFactoryBeanMethod(MethodReader method) {
        this.writer.append("  public static void build_%s(Builder builder) {", method.getName()).eol();
        method.buildAddFor(this.writer);
        this.writer.append(method.builderGetFactory()).eol();
        this.writer.append(method.builderBuildBean()).eol();
        method.builderBuildAddBean(this.writer);
        this.writer.append("    }").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeStaticFactoryMethod() {
        MethodReader constructor = this.beanReader.getConstructor();
        if (constructor == null) {
            this.ctx.logError(this.beanReader.getBeanType(), "Unable to determine constructor to use?", new Object[0]);
            return;
        }
        int providerIndex = 0;
        this.writer.append("  public static void build(Builder builder");
        for (MethodReader.MethodParam param : constructor.getParams()) {
            if (!param.isGenericType()) continue;
            param.addProviderParam(this.writer, providerIndex++);
        }
        this.writer.append(") {").eol();
        this.beanReader.buildAddFor(this.writer);
        this.writer.append("      %s bean = new %s(", this.shortName, this.shortName);
        List<MethodReader.MethodParam> params = constructor.getParams();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                this.writer.append(",");
            }
            this.writer.append(params.get(i).builderGetDependency());
        }
        this.writer.append(");").eol();
        this.beanReader.buildRegister(this.writer);
        if (this.beanReader.isLifecycleRequired()) {
            this.beanReader.buildAddLifecycle(this.writer);
        }
        if (this.beanReader.isFieldInjectionRequired()) {
            this.writer.append("      builder.addInjector(b -> {").eol();
            for (FieldReader fieldReader : this.beanReader.getInjectFields()) {
                String fieldName = fieldReader.getFieldName();
                String getDependency = fieldReader.builderGetDependency();
                this.writer.append("        $bean.%s = %s;", fieldName, getDependency).eol();
            }
            this.writer.append("      });").eol();
        }
        this.writer.append("    }").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer);
    }

    private void lifecycleMethod(String method, Element methodElement) {
        this.writer.append("  @Override").eol();
        this.writer.append("  public void %s() {", method).eol();
        if (methodElement == null) {
            this.writer.append("    // do nothing for %s", method).eol();
        } else {
            String methodName = methodElement.getSimpleName().toString();
            this.writer.append("    bean.%s();", methodName).eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeLifecycleWrapper() {
        if (this.beanReader.isLifecycleWrapperRequired()) {
            this.writer.append("  private final %s bean;", this.shortName).eol().eol();
            this.writer.append("  public %s$di(%s bean) {", this.shortName, this.shortName).eol();
            this.writer.append("    this.bean = bean;").eol();
            this.writer.append("  }").eol().eol();
            this.lifecycleMethod("postConstruct", this.beanReader.getPostConstructMethod());
            this.lifecycleMethod("preDestroy", this.beanReader.getPreDestroyMethod());
        }
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        if (this.ctx.isGeneratedAvailable()) {
            this.writer.append("@Generated(\"io.dinject.generator\")").eol();
        }
        this.writer.append("public class ").append(this.shortName).append("$di ");
        if (this.beanReader.isLifecycleWrapperRequired()) {
            this.writer.append("implements BeanLifecycle ");
        }
        this.writer.append(" {").eol().eol();
    }

    private void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }
}

