/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import io.dinject.generator.Append;
import io.dinject.generator.MetaData;
import io.dinject.generator.MetaDataOrdering;
import io.dinject.generator.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

class SimpleFactoryWriter {
    private final MetaDataOrdering ordering;
    private final ProcessingContext processingContext;
    private final String factoryPackage;
    private final String factoryShortName;
    private final String factoryFullName;
    private Append writer;

    SimpleFactoryWriter(MetaDataOrdering ordering, ProcessingContext processingContext) {
        this.ordering = ordering;
        this.processingContext = processingContext;
        String pkg = processingContext.getContextPackage();
        this.factoryPackage = pkg != null ? pkg : ordering.getTopPackage();
        processingContext.deriveContextName(this.factoryPackage);
        this.factoryShortName = "_di$Factory";
        this.factoryFullName = this.factoryPackage + "." + this.factoryShortName;
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeStartClass();
        this.writeCreateMethod();
        this.writeBuildMethods();
        this.writeEndClass();
        this.writer.close();
        this.writeServicesFile();
    }

    private void writeServicesFile() {
        try {
            FileObject jfo = this.processingContext.createMetaInfWriter();
            if (jfo != null) {
                Writer writer = jfo.openWriter();
                writer.write(this.factoryFullName);
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.processingContext.logError("Failed to write services file " + e.getMessage(), new Object[0]);
        }
    }

    private void writeBuildMethods() {
        for (MetaData metaData : this.ordering.getOrdered()) {
            this.writer.append(metaData.buildMethod(this.ordering)).eol();
        }
    }

    private void writeCreateMethod() {
        this.writer.append("  @Override").eol();
        this.writer.append("  public BeanContext createContext(Builder parent) {").eol();
        this.writer.append("    builder.setParent(parent);").eol();
        for (MetaData metaData : this.ordering.getOrdered()) {
            this.writer.append("    build_%s();", metaData.getShortType()).eol();
        }
        this.writer.append("    return builder.build();").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writePackage() {
        this.writer.append("package %s;", this.factoryPackage).eol().eol();
        String generated = this.processingContext.getGeneratedAnnotation();
        if (generated != null) {
            this.writer.append("import %s;", generated).eol();
        }
        this.writer.append("import io.dinject.BeanContext;").eol();
        this.writer.append("import io.dinject.ContextModule;").eol();
        this.writer.append("import io.dinject.core.BeanContextFactory;").eol();
        this.writer.append("import io.dinject.core.BuilderFactory;").eol();
        this.writer.append("import io.dinject.core.Builder;").eol();
        this.writer.append("import io.dinject.core.DependencyMeta;").eol().eol();
        for (String type : this.ordering.getImportTypes()) {
            this.writer.append("import %s;", type).eol();
        }
        this.writer.eol();
    }

    private void writeStartClass() {
        this.processingContext.buildAtContextModule(this.writer);
        this.writer.append("public class %s implements BeanContextFactory {", this.factoryShortName).eol().eol();
        this.writer.append("  private final Builder builder;").eol().eol();
        this.writer.append("  public %s() {", this.factoryShortName).eol();
        this.processingContext.buildNewBuilder(this.writer);
        this.writer.append("  }").eol().eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public String getName() {").eol();
        this.writer.append("    return builder.getName();").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public String[] getProvides() {").eol();
        this.writer.append("    return builder.getProvides();").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public String[] getDependsOn() {").eol();
        this.writer.append("    return builder.getDependsOn();").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeEndClass() {
        this.writer.append("}").eol();
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.processingContext.createWriter(this.factoryFullName);
        return jfo.openWriter();
    }
}

