/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.generator;

import javax.inject.Named;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;

class Util {
    Util() {
    }

    static String classOfMethod(String method) {
        return Util.packageOf(method);
    }

    static String shortMethod(String method) {
        int p = method.lastIndexOf(46);
        if (p > -1 && (p = method.lastIndexOf(46, p - 1)) > -1) {
            return method.substring(p + 1);
        }
        return method;
    }

    static String packageOf(String cls) {
        int pos = cls.lastIndexOf(46);
        return pos == -1 ? "" : cls.substring(0, pos);
    }

    static String unwrapProvider(String maybeProvider) {
        if (Util.isProvider(maybeProvider)) {
            return Util.extractProviderType(maybeProvider);
        }
        return maybeProvider;
    }

    static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        return fullType.substring(p + 1);
    }

    static String extractOptionalType(String rawType) {
        return rawType.substring(19, rawType.length() - 1);
    }

    static boolean isOptional(String rawType) {
        return rawType.startsWith("java.util.Optional<");
    }

    static String extractList(String rawType) {
        String listType = rawType.substring(15, rawType.length() - 1);
        if (listType.startsWith("? extends")) {
            return listType.substring(10);
        }
        return listType;
    }

    static boolean isList(String rawType) {
        return rawType.startsWith("java.util.List<");
    }

    private static boolean isProvider(String rawType) {
        return rawType.startsWith("javax.inject.Provider<");
    }

    private static String extractProviderType(String rawType) {
        return rawType.substring(22, rawType.length() - 1);
    }

    static String commonParent(String currentTop, String aPackage) {
        int next;
        if (aPackage == null) {
            return currentTop;
        }
        if (currentTop == null) {
            return aPackage;
        }
        if (aPackage.startsWith(currentTop)) {
            return currentTop;
        }
        do {
            if ((next = currentTop.lastIndexOf(46)) <= -1 || !aPackage.startsWith(currentTop = currentTop.substring(0, next))) continue;
            return currentTop;
        } while (next > -1);
        return currentTop;
    }

    public static String getNamed(Element p) {
        Named named = p.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        for (AnnotationMirror annotationMirror : p.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Qualifier qualifier = annotationType.asElement().getAnnotation(Qualifier.class);
            if (qualifier == null) continue;
            return Util.shortName(annotationType.toString());
        }
        return null;
    }

    public static String addForInterface(String interfaceType) {
        if (interfaceType.contains("<")) {
            return null;
        }
        return Util.shortName(interfaceType);
    }
}

